/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatusReport
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatusReport> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(StatusReport.getter(StatusReport::status)).setter(StatusReport.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("Status").build()}).build();
    private static final SdkField<Instant> CHECKED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CheckedTime").getter(StatusReport.getter(StatusReport::checkedTime)).setter(StatusReport.setter(Builder::checkedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckedTime").unmarshallLocationName("CheckedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, CHECKED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String status;
    private final Instant checkedTime;

    private StatusReport(BuilderImpl builder) {
        this.status = builder.status;
        this.checkedTime = builder.checkedTime;
    }

    public final String status() {
        return this.status;
    }

    public final Instant checkedTime() {
        return this.checkedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusReport)) {
            return false;
        }
        StatusReport other = (StatusReport)obj;
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.checkedTime(), other.checkedTime());
    }

    public final String toString() {
        return ToString.builder((String)"StatusReport").add("Status", (Object)this.status()).add("CheckedTime", (Object)this.checkedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CheckedTime": {
                return Optional.ofNullable(clazz.cast(this.checkedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StatusReport, T> g) {
        return obj -> g.apply((StatusReport)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private Instant checkedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StatusReport model) {
            this.status(model.status);
            this.checkedTime(model.checkedTime);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCheckedTime() {
            return this.checkedTime;
        }

        public final void setCheckedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
        }

        @Override
        public final Builder checkedTime(Instant checkedTime) {
            this.checkedTime = checkedTime;
            return this;
        }

        public StatusReport build() {
            return new StatusReport(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatusReport> {
        public Builder status(String var1);

        public Builder checkedTime(Instant var1);
    }
}

