/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53.Route53Client;
import software.amazon.awssdk.services.route53.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53.model.CollectionSummary;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsRequest;
import software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse;

public class ListCidrCollectionsIterable
implements SdkIterable<ListCidrCollectionsResponse> {
    private final Route53Client client;
    private final ListCidrCollectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCidrCollectionsIterable(Route53Client client, ListCidrCollectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCidrCollectionsResponseFetcher();
    }

    public Iterator<ListCidrCollectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CollectionSummary> cidrCollections() {
        Function<ListCidrCollectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cidrCollections() != null) {
                return response.cidrCollections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCidrCollectionsResponseFetcher
    implements SyncPageFetcher<ListCidrCollectionsResponse> {
        private ListCidrCollectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCidrCollectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCidrCollectionsResponse nextPage(ListCidrCollectionsResponse previousPage) {
            if (previousPage == null) {
                return ListCidrCollectionsIterable.this.client.listCidrCollections(ListCidrCollectionsIterable.this.firstRequest);
            }
            return ListCidrCollectionsIterable.this.client.listCidrCollections((ListCidrCollectionsRequest)((Object)ListCidrCollectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

