/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53resolver.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.route53resolver.model.OutpostResolverStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OutpostResolver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OutpostResolver> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(OutpostResolver.getter(OutpostResolver::arn)).setter(OutpostResolver.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreationTime").getter(OutpostResolver.getter(OutpostResolver::creationTime)).setter(OutpostResolver.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> MODIFICATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModificationTime").getter(OutpostResolver.getter(OutpostResolver::modificationTime)).setter(OutpostResolver.setter(Builder::modificationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationTime").build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(OutpostResolver.getter(OutpostResolver::creatorRequestId)).setter(OutpostResolver.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(OutpostResolver.getter(OutpostResolver::id)).setter(OutpostResolver.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(OutpostResolver.getter(OutpostResolver::instanceCount)).setter(OutpostResolver.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<String> PREFERRED_INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredInstanceType").getter(OutpostResolver.getter(OutpostResolver::preferredInstanceType)).setter(OutpostResolver.setter(Builder::preferredInstanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredInstanceType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(OutpostResolver.getter(OutpostResolver::name)).setter(OutpostResolver.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(OutpostResolver.getter(OutpostResolver::statusAsString)).setter(OutpostResolver.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(OutpostResolver.getter(OutpostResolver::statusMessage)).setter(OutpostResolver.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(OutpostResolver.getter(OutpostResolver::outpostArn)).setter(OutpostResolver.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATION_TIME_FIELD, MODIFICATION_TIME_FIELD, CREATOR_REQUEST_ID_FIELD, ID_FIELD, INSTANCE_COUNT_FIELD, PREFERRED_INSTANCE_TYPE_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, OUTPOST_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String creationTime;
    private final String modificationTime;
    private final String creatorRequestId;
    private final String id;
    private final Integer instanceCount;
    private final String preferredInstanceType;
    private final String name;
    private final String status;
    private final String statusMessage;
    private final String outpostArn;

    private OutpostResolver(BuilderImpl builder) {
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.modificationTime = builder.modificationTime;
        this.creatorRequestId = builder.creatorRequestId;
        this.id = builder.id;
        this.instanceCount = builder.instanceCount;
        this.preferredInstanceType = builder.preferredInstanceType;
        this.name = builder.name;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.outpostArn = builder.outpostArn;
    }

    public final String arn() {
        return this.arn;
    }

    public final String creationTime() {
        return this.creationTime;
    }

    public final String modificationTime() {
        return this.modificationTime;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    public final String id() {
        return this.id;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String preferredInstanceType() {
        return this.preferredInstanceType;
    }

    public final String name() {
        return this.name;
    }

    public final OutpostResolverStatus status() {
        return OutpostResolverStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredInstanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutpostResolver)) {
            return false;
        }
        OutpostResolver other = (OutpostResolver)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modificationTime(), other.modificationTime()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.preferredInstanceType(), other.preferredInstanceType()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.outpostArn(), other.outpostArn());
    }

    public final String toString() {
        return ToString.builder((String)"OutpostResolver").add("Arn", (Object)this.arn()).add("CreationTime", (Object)this.creationTime()).add("ModificationTime", (Object)this.modificationTime()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Id", (Object)this.id()).add("InstanceCount", (Object)this.instanceCount()).add("PreferredInstanceType", (Object)this.preferredInstanceType()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("OutpostArn", (Object)this.outpostArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "ModificationTime": {
                return Optional.ofNullable(clazz.cast(this.modificationTime()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "PreferredInstanceType": {
                return Optional.ofNullable(clazz.cast(this.preferredInstanceType()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OutpostResolver, T> g) {
        return obj -> g.apply((OutpostResolver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String creationTime;
        private String modificationTime;
        private String creatorRequestId;
        private String id;
        private Integer instanceCount;
        private String preferredInstanceType;
        private String name;
        private String status;
        private String statusMessage;
        private String outpostArn;

        private BuilderImpl() {
        }

        private BuilderImpl(OutpostResolver model) {
            this.arn(model.arn);
            this.creationTime(model.creationTime);
            this.modificationTime(model.modificationTime);
            this.creatorRequestId(model.creatorRequestId);
            this.id(model.id);
            this.instanceCount(model.instanceCount);
            this.preferredInstanceType(model.preferredInstanceType);
            this.name(model.name);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.outpostArn(model.outpostArn);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(String creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(String creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModificationTime() {
            return this.modificationTime;
        }

        public final void setModificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
        }

        @Override
        public final Builder modificationTime(String modificationTime) {
            this.modificationTime = modificationTime;
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getPreferredInstanceType() {
            return this.preferredInstanceType;
        }

        public final void setPreferredInstanceType(String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
        }

        @Override
        public final Builder preferredInstanceType(String preferredInstanceType) {
            this.preferredInstanceType = preferredInstanceType;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OutpostResolverStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public OutpostResolver build() {
            return new OutpostResolver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OutpostResolver> {
        public Builder arn(String var1);

        public Builder creationTime(String var1);

        public Builder modificationTime(String var1);

        public Builder creatorRequestId(String var1);

        public Builder id(String var1);

        public Builder instanceCount(Integer var1);

        public Builder preferredInstanceType(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(OutpostResolverStatus var1);

        public Builder statusMessage(String var1);

        public Builder outpostArn(String var1);
    }
}

