/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessGrantsLocationsResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListAccessGrantsLocationsResponse.Builder, ListAccessGrantsLocationsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessGrantsLocationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<ListAccessGrantsLocationsEntry>> ACCESS_GRANTS_LOCATIONS_LIST_FIELD = SdkField
            .<List<ListAccessGrantsLocationsEntry>> builder(MarshallingType.LIST)
            .memberName("AccessGrantsLocationsList")
            .getter(getter(ListAccessGrantsLocationsResponse::accessGrantsLocationsList))
            .setter(setter(Builder::accessGrantsLocationsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsLocationsList")
                    .unmarshallLocationName("AccessGrantsLocationsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccessGrantsLocation")
                            .memberFieldInfo(
                                    SdkField.<ListAccessGrantsLocationsEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListAccessGrantsLocationsEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccessGrantsLocation")
                                                    .unmarshallLocationName("AccessGrantsLocation").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ACCESS_GRANTS_LOCATIONS_LIST_FIELD));

    private final String nextToken;

    private final List<ListAccessGrantsLocationsEntry> accessGrantsLocationsList;

    private ListAccessGrantsLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessGrantsLocationsList = builder.accessGrantsLocationsList;
    }

    /**
     * <p>
     * A pagination token to request the next page of results. Pass this value into a subsequent
     * <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return A pagination token to request the next page of results. Pass this value into a subsequent
     *         <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessGrantsLocationsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAccessGrantsLocationsList() {
        return accessGrantsLocationsList != null && !(accessGrantsLocationsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A container for a list of registered locations in an S3 Access Grants instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessGrantsLocationsList} method.
     * </p>
     * 
     * @return A container for a list of registered locations in an S3 Access Grants instance.
     */
    public final List<ListAccessGrantsLocationsEntry> accessGrantsLocationsList() {
        return accessGrantsLocationsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessGrantsLocationsList() ? accessGrantsLocationsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsLocationsResponse)) {
            return false;
        }
        ListAccessGrantsLocationsResponse other = (ListAccessGrantsLocationsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasAccessGrantsLocationsList() == other.hasAccessGrantsLocationsList()
                && Objects.equals(accessGrantsLocationsList(), other.accessGrantsLocationsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessGrantsLocationsResponse").add("NextToken", nextToken())
                .add("AccessGrantsLocationsList", hasAccessGrantsLocationsList() ? accessGrantsLocationsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AccessGrantsLocationsList":
            return Optional.ofNullable(clazz.cast(accessGrantsLocationsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsLocationsResponse, T> g) {
        return obj -> g.apply((ListAccessGrantsLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessGrantsLocationsResponse> {
        /**
         * <p>
         * A pagination token to request the next page of results. Pass this value into a subsequent
         * <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to request the next page of results. Pass this value into a subsequent
         *        <code>List Access Grants Locations</code> request in order to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A container for a list of registered locations in an S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsLocationsList
         *        A container for a list of registered locations in an S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationsList(Collection<ListAccessGrantsLocationsEntry> accessGrantsLocationsList);

        /**
         * <p>
         * A container for a list of registered locations in an S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsLocationsList
         *        A container for a list of registered locations in an S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsLocationsList(ListAccessGrantsLocationsEntry... accessGrantsLocationsList);

        /**
         * <p>
         * A container for a list of registered locations in an S3 Access Grants instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsEntry.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsEntry.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #accessGrantsLocationsList(List<ListAccessGrantsLocationsEntry>)}.
         * 
         * @param accessGrantsLocationsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantsLocationsEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessGrantsLocationsList(java.util.Collection<ListAccessGrantsLocationsEntry>)
         */
        Builder accessGrantsLocationsList(Consumer<ListAccessGrantsLocationsEntry.Builder>... accessGrantsLocationsList);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListAccessGrantsLocationsEntry> accessGrantsLocationsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsLocationsResponse model) {
            super(model);
            nextToken(model.nextToken);
            accessGrantsLocationsList(model.accessGrantsLocationsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListAccessGrantsLocationsEntry.Builder> getAccessGrantsLocationsList() {
            List<ListAccessGrantsLocationsEntry.Builder> result = AccessGrantsLocationsListCopier
                    .copyToBuilder(this.accessGrantsLocationsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessGrantsLocationsList(
                Collection<ListAccessGrantsLocationsEntry.BuilderImpl> accessGrantsLocationsList) {
            this.accessGrantsLocationsList = AccessGrantsLocationsListCopier.copyFromBuilder(accessGrantsLocationsList);
        }

        @Override
        public final Builder accessGrantsLocationsList(Collection<ListAccessGrantsLocationsEntry> accessGrantsLocationsList) {
            this.accessGrantsLocationsList = AccessGrantsLocationsListCopier.copy(accessGrantsLocationsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsLocationsList(ListAccessGrantsLocationsEntry... accessGrantsLocationsList) {
            accessGrantsLocationsList(Arrays.asList(accessGrantsLocationsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsLocationsList(
                Consumer<ListAccessGrantsLocationsEntry.Builder>... accessGrantsLocationsList) {
            accessGrantsLocationsList(Stream.of(accessGrantsLocationsList)
                    .map(c -> ListAccessGrantsLocationsEntry.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessGrantsLocationsResponse build() {
            return new ListAccessGrantsLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
