/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessGrantsResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListAccessGrantsResponse.Builder, ListAccessGrantsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessGrantsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final SdkField<List<ListAccessGrantEntry>> ACCESS_GRANTS_LIST_FIELD = SdkField
            .<List<ListAccessGrantEntry>> builder(MarshallingType.LIST)
            .memberName("AccessGrantsList")
            .getter(getter(ListAccessGrantsResponse::accessGrantsList))
            .setter(setter(Builder::accessGrantsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessGrantsList")
                    .unmarshallLocationName("AccessGrantsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccessGrant")
                            .memberFieldInfo(
                                    SdkField.<ListAccessGrantEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListAccessGrantEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccessGrant").unmarshallLocationName("AccessGrant").build())
                                            .build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            ACCESS_GRANTS_LIST_FIELD));

    private final String nextToken;

    private final List<ListAccessGrantEntry> accessGrantsList;

    private ListAccessGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.accessGrantsList = builder.accessGrantsList;
    }

    /**
     * <p>
     * A pagination token to request the next page of results. Pass this value into a subsequent
     * <code>List Access Grants</code> request in order to retrieve the next page of results.
     * </p>
     * 
     * @return A pagination token to request the next page of results. Pass this value into a subsequent
     *         <code>List Access Grants</code> request in order to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AccessGrantsList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAccessGrantsList() {
        return accessGrantsList != null && !(accessGrantsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A container for a list of grants in an S3 Access Grants instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAccessGrantsList} method.
     * </p>
     * 
     * @return A container for a list of grants in an S3 Access Grants instance.
     */
    public final List<ListAccessGrantEntry> accessGrantsList() {
        return accessGrantsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccessGrantsList() ? accessGrantsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessGrantsResponse)) {
            return false;
        }
        ListAccessGrantsResponse other = (ListAccessGrantsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasAccessGrantsList() == other.hasAccessGrantsList()
                && Objects.equals(accessGrantsList(), other.accessGrantsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessGrantsResponse").add("NextToken", nextToken())
                .add("AccessGrantsList", hasAccessGrantsList() ? accessGrantsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "AccessGrantsList":
            return Optional.ofNullable(clazz.cast(accessGrantsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessGrantsResponse, T> g) {
        return obj -> g.apply((ListAccessGrantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessGrantsResponse> {
        /**
         * <p>
         * A pagination token to request the next page of results. Pass this value into a subsequent
         * <code>List Access Grants</code> request in order to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A pagination token to request the next page of results. Pass this value into a subsequent
         *        <code>List Access Grants</code> request in order to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A container for a list of grants in an S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsList
         *        A container for a list of grants in an S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsList(Collection<ListAccessGrantEntry> accessGrantsList);

        /**
         * <p>
         * A container for a list of grants in an S3 Access Grants instance.
         * </p>
         * 
         * @param accessGrantsList
         *        A container for a list of grants in an S3 Access Grants instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessGrantsList(ListAccessGrantEntry... accessGrantsList);

        /**
         * <p>
         * A container for a list of grants in an S3 Access Grants instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantEntry.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantEntry.Builder#build()} is called
         * immediately and its result is passed to {@link #accessGrantsList(List<ListAccessGrantEntry>)}.
         * 
         * @param accessGrantsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.s3control.model.ListAccessGrantEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessGrantsList(java.util.Collection<ListAccessGrantEntry>)
         */
        Builder accessGrantsList(Consumer<ListAccessGrantEntry.Builder>... accessGrantsList);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListAccessGrantEntry> accessGrantsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessGrantsResponse model) {
            super(model);
            nextToken(model.nextToken);
            accessGrantsList(model.accessGrantsList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListAccessGrantEntry.Builder> getAccessGrantsList() {
            List<ListAccessGrantEntry.Builder> result = AccessGrantsListCopier.copyToBuilder(this.accessGrantsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAccessGrantsList(Collection<ListAccessGrantEntry.BuilderImpl> accessGrantsList) {
            this.accessGrantsList = AccessGrantsListCopier.copyFromBuilder(accessGrantsList);
        }

        @Override
        public final Builder accessGrantsList(Collection<ListAccessGrantEntry> accessGrantsList) {
            this.accessGrantsList = AccessGrantsListCopier.copy(accessGrantsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsList(ListAccessGrantEntry... accessGrantsList) {
            accessGrantsList(Arrays.asList(accessGrantsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessGrantsList(Consumer<ListAccessGrantEntry.Builder>... accessGrantsList) {
            accessGrantsList(Stream.of(accessGrantsList).map(c -> ListAccessGrantEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccessGrantsResponse build() {
            return new ListAccessGrantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
