/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the Storage Lens groups to include in the Storage Lens group aggregation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageLensGroupLevel implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageLensGroupLevel.Builder, StorageLensGroupLevel> {
    private static final SdkField<StorageLensGroupLevelSelectionCriteria> SELECTION_CRITERIA_FIELD = SdkField
            .<StorageLensGroupLevelSelectionCriteria> builder(MarshallingType.SDK_POJO)
            .memberName("SelectionCriteria")
            .getter(getter(StorageLensGroupLevel::selectionCriteria))
            .setter(setter(Builder::selectionCriteria))
            .constructor(StorageLensGroupLevelSelectionCriteria::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionCriteria")
                    .unmarshallLocationName("SelectionCriteria").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_CRITERIA_FIELD));

    private static final long serialVersionUID = 1L;

    private final StorageLensGroupLevelSelectionCriteria selectionCriteria;

    private StorageLensGroupLevel(BuilderImpl builder) {
        this.selectionCriteria = builder.selectionCriteria;
    }

    /**
     * <p>
     * Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If this
     * value is left null, then all Storage Lens groups are selected.
     * </p>
     * 
     * @return Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If
     *         this value is left null, then all Storage Lens groups are selected.
     */
    public final StorageLensGroupLevelSelectionCriteria selectionCriteria() {
        return selectionCriteria;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectionCriteria());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageLensGroupLevel)) {
            return false;
        }
        StorageLensGroupLevel other = (StorageLensGroupLevel) obj;
        return Objects.equals(selectionCriteria(), other.selectionCriteria());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageLensGroupLevel").add("SelectionCriteria", selectionCriteria()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectionCriteria":
            return Optional.ofNullable(clazz.cast(selectionCriteria()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StorageLensGroupLevel, T> g) {
        return obj -> g.apply((StorageLensGroupLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageLensGroupLevel> {
        /**
         * <p>
         * Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If this
         * value is left null, then all Storage Lens groups are selected.
         * </p>
         * 
         * @param selectionCriteria
         *        Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation.
         *        If this value is left null, then all Storage Lens groups are selected.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectionCriteria(StorageLensGroupLevelSelectionCriteria selectionCriteria);

        /**
         * <p>
         * Indicates which Storage Lens group ARNs to include or exclude in the Storage Lens group aggregation. If this
         * value is left null, then all Storage Lens groups are selected.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StorageLensGroupLevelSelectionCriteria.Builder} avoiding the need to create one manually via
         * {@link StorageLensGroupLevelSelectionCriteria#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StorageLensGroupLevelSelectionCriteria.Builder#build()} is called
         * immediately and its result is passed to {@link #selectionCriteria(StorageLensGroupLevelSelectionCriteria)}.
         * 
         * @param selectionCriteria
         *        a consumer that will call methods on {@link StorageLensGroupLevelSelectionCriteria.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectionCriteria(StorageLensGroupLevelSelectionCriteria)
         */
        default Builder selectionCriteria(Consumer<StorageLensGroupLevelSelectionCriteria.Builder> selectionCriteria) {
            return selectionCriteria(StorageLensGroupLevelSelectionCriteria.builder().applyMutation(selectionCriteria).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private StorageLensGroupLevelSelectionCriteria selectionCriteria;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageLensGroupLevel model) {
            selectionCriteria(model.selectionCriteria);
        }

        public final StorageLensGroupLevelSelectionCriteria.Builder getSelectionCriteria() {
            return selectionCriteria != null ? selectionCriteria.toBuilder() : null;
        }

        public final void setSelectionCriteria(StorageLensGroupLevelSelectionCriteria.BuilderImpl selectionCriteria) {
            this.selectionCriteria = selectionCriteria != null ? selectionCriteria.build() : null;
        }

        @Override
        public final Builder selectionCriteria(StorageLensGroupLevelSelectionCriteria selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        @Override
        public StorageLensGroupLevel build() {
            return new StorageLensGroupLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
