/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3control.model.S3ControlRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAccessGrantsLocationRequest
extends S3ControlRequest
implements ToCopyableBuilder<Builder, DeleteAccessGrantsLocationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DeleteAccessGrantsLocationRequest.getter(DeleteAccessGrantsLocationRequest::accountId)).setter(DeleteAccessGrantsLocationRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id").unmarshallLocationName("x-amz-account-id").build()}).build();
    private static final SdkField<String> ACCESS_GRANTS_LOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessGrantsLocationId").getter(DeleteAccessGrantsLocationRequest.getter(DeleteAccessGrantsLocationRequest::accessGrantsLocationId)).setter(DeleteAccessGrantsLocationRequest.setter(Builder::accessGrantsLocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").unmarshallLocationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ACCESS_GRANTS_LOCATION_ID_FIELD));
    private final String accountId;
    private final String accessGrantsLocationId;

    private DeleteAccessGrantsLocationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.accessGrantsLocationId = builder.accessGrantsLocationId;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String accessGrantsLocationId() {
        return this.accessGrantsLocationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessGrantsLocationId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccessGrantsLocationRequest)) {
            return false;
        }
        DeleteAccessGrantsLocationRequest other = (DeleteAccessGrantsLocationRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.accessGrantsLocationId(), other.accessGrantsLocationId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAccessGrantsLocationRequest").add("AccountId", (Object)this.accountId()).add("AccessGrantsLocationId", (Object)this.accessGrantsLocationId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "AccessGrantsLocationId": {
                return Optional.ofNullable(clazz.cast(this.accessGrantsLocationId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccessGrantsLocationRequest, T> g) {
        return obj -> g.apply((DeleteAccessGrantsLocationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3ControlRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String accessGrantsLocationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccessGrantsLocationRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.accessGrantsLocationId(model.accessGrantsLocationId);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getAccessGrantsLocationId() {
            return this.accessGrantsLocationId;
        }

        public final void setAccessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
        }

        @Override
        public final Builder accessGrantsLocationId(String accessGrantsLocationId) {
            this.accessGrantsLocationId = accessGrantsLocationId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccessGrantsLocationRequest build() {
            return new DeleteAccessGrantsLocationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3ControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAccessGrantsLocationRequest> {
        public Builder accountId(String var1);

        public Builder accessGrantsLocationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

