/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.BatchDataCaptureConfig;
import software.amazon.awssdk.services.sagemaker.model.BatchStrategy;
import software.amazon.awssdk.services.sagemaker.model.DataProcessing;
import software.amazon.awssdk.services.sagemaker.model.ExperimentConfig;
import software.amazon.awssdk.services.sagemaker.model.ModelClientConfig;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.TransformInput;
import software.amazon.awssdk.services.sagemaker.model.TransformJobStatus;
import software.amazon.awssdk.services.sagemaker.model.TransformOutput;
import software.amazon.awssdk.services.sagemaker.model.TransformResources;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransformJob
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransformJob> {
    private static final SdkField<String> TRANSFORM_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobName").getter(TransformJob.getter(TransformJob::transformJobName)).setter(TransformJob.setter(Builder::transformJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobName").build()}).build();
    private static final SdkField<String> TRANSFORM_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobArn").getter(TransformJob.getter(TransformJob::transformJobArn)).setter(TransformJob.setter(Builder::transformJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobArn").build()}).build();
    private static final SdkField<String> TRANSFORM_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformJobStatus").getter(TransformJob.getter(TransformJob::transformJobStatusAsString)).setter(TransformJob.setter(Builder::transformJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformJobStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(TransformJob.getter(TransformJob::failureReason)).setter(TransformJob.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(TransformJob.getter(TransformJob::modelName)).setter(TransformJob.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_TRANSFORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentTransforms").getter(TransformJob.getter(TransformJob::maxConcurrentTransforms)).setter(TransformJob.setter(Builder::maxConcurrentTransforms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentTransforms").build()}).build();
    private static final SdkField<ModelClientConfig> MODEL_CLIENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelClientConfig").getter(TransformJob.getter(TransformJob::modelClientConfig)).setter(TransformJob.setter(Builder::modelClientConfig)).constructor(ModelClientConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelClientConfig").build()}).build();
    private static final SdkField<Integer> MAX_PAYLOAD_IN_MB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxPayloadInMB").getter(TransformJob.getter(TransformJob::maxPayloadInMB)).setter(TransformJob.setter(Builder::maxPayloadInMB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPayloadInMB").build()}).build();
    private static final SdkField<String> BATCH_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchStrategy").getter(TransformJob.getter(TransformJob::batchStrategyAsString)).setter(TransformJob.setter(Builder::batchStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchStrategy").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(TransformJob.getter(TransformJob::environment)).setter(TransformJob.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<TransformInput> TRANSFORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformInput").getter(TransformJob.getter(TransformJob::transformInput)).setter(TransformJob.setter(Builder::transformInput)).constructor(TransformInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformInput").build()}).build();
    private static final SdkField<TransformOutput> TRANSFORM_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformOutput").getter(TransformJob.getter(TransformJob::transformOutput)).setter(TransformJob.setter(Builder::transformOutput)).constructor(TransformOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformOutput").build()}).build();
    private static final SdkField<TransformResources> TRANSFORM_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TransformResources").getter(TransformJob.getter(TransformJob::transformResources)).setter(TransformJob.setter(Builder::transformResources)).constructor(TransformResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformResources").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(TransformJob.getter(TransformJob::creationTime)).setter(TransformJob.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> TRANSFORM_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TransformStartTime").getter(TransformJob.getter(TransformJob::transformStartTime)).setter(TransformJob.setter(Builder::transformStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformStartTime").build()}).build();
    private static final SdkField<Instant> TRANSFORM_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("TransformEndTime").getter(TransformJob.getter(TransformJob::transformEndTime)).setter(TransformJob.setter(Builder::transformEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformEndTime").build()}).build();
    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobArn").getter(TransformJob.getter(TransformJob::labelingJobArn)).setter(TransformJob.setter(Builder::labelingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()}).build();
    private static final SdkField<String> AUTO_ML_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoMLJobArn").getter(TransformJob.getter(TransformJob::autoMLJobArn)).setter(TransformJob.setter(Builder::autoMLJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMLJobArn").build()}).build();
    private static final SdkField<DataProcessing> DATA_PROCESSING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataProcessing").getter(TransformJob.getter(TransformJob::dataProcessing)).setter(TransformJob.setter(Builder::dataProcessing)).constructor(DataProcessing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataProcessing").build()}).build();
    private static final SdkField<ExperimentConfig> EXPERIMENT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExperimentConfig").getter(TransformJob.getter(TransformJob::experimentConfig)).setter(TransformJob.setter(Builder::experimentConfig)).constructor(ExperimentConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TransformJob.getter(TransformJob::tags)).setter(TransformJob.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<BatchDataCaptureConfig> DATA_CAPTURE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataCaptureConfig").getter(TransformJob.getter(TransformJob::dataCaptureConfig)).setter(TransformJob.setter(Builder::dataCaptureConfig)).constructor(BatchDataCaptureConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataCaptureConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_JOB_NAME_FIELD, TRANSFORM_JOB_ARN_FIELD, TRANSFORM_JOB_STATUS_FIELD, FAILURE_REASON_FIELD, MODEL_NAME_FIELD, MAX_CONCURRENT_TRANSFORMS_FIELD, MODEL_CLIENT_CONFIG_FIELD, MAX_PAYLOAD_IN_MB_FIELD, BATCH_STRATEGY_FIELD, ENVIRONMENT_FIELD, TRANSFORM_INPUT_FIELD, TRANSFORM_OUTPUT_FIELD, TRANSFORM_RESOURCES_FIELD, CREATION_TIME_FIELD, TRANSFORM_START_TIME_FIELD, TRANSFORM_END_TIME_FIELD, LABELING_JOB_ARN_FIELD, AUTO_ML_JOB_ARN_FIELD, DATA_PROCESSING_FIELD, EXPERIMENT_CONFIG_FIELD, TAGS_FIELD, DATA_CAPTURE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transformJobName;
    private final String transformJobArn;
    private final String transformJobStatus;
    private final String failureReason;
    private final String modelName;
    private final Integer maxConcurrentTransforms;
    private final ModelClientConfig modelClientConfig;
    private final Integer maxPayloadInMB;
    private final String batchStrategy;
    private final Map<String, String> environment;
    private final TransformInput transformInput;
    private final TransformOutput transformOutput;
    private final TransformResources transformResources;
    private final Instant creationTime;
    private final Instant transformStartTime;
    private final Instant transformEndTime;
    private final String labelingJobArn;
    private final String autoMLJobArn;
    private final DataProcessing dataProcessing;
    private final ExperimentConfig experimentConfig;
    private final List<Tag> tags;
    private final BatchDataCaptureConfig dataCaptureConfig;

    private TransformJob(BuilderImpl builder) {
        this.transformJobName = builder.transformJobName;
        this.transformJobArn = builder.transformJobArn;
        this.transformJobStatus = builder.transformJobStatus;
        this.failureReason = builder.failureReason;
        this.modelName = builder.modelName;
        this.maxConcurrentTransforms = builder.maxConcurrentTransforms;
        this.modelClientConfig = builder.modelClientConfig;
        this.maxPayloadInMB = builder.maxPayloadInMB;
        this.batchStrategy = builder.batchStrategy;
        this.environment = builder.environment;
        this.transformInput = builder.transformInput;
        this.transformOutput = builder.transformOutput;
        this.transformResources = builder.transformResources;
        this.creationTime = builder.creationTime;
        this.transformStartTime = builder.transformStartTime;
        this.transformEndTime = builder.transformEndTime;
        this.labelingJobArn = builder.labelingJobArn;
        this.autoMLJobArn = builder.autoMLJobArn;
        this.dataProcessing = builder.dataProcessing;
        this.experimentConfig = builder.experimentConfig;
        this.tags = builder.tags;
        this.dataCaptureConfig = builder.dataCaptureConfig;
    }

    public final String transformJobName() {
        return this.transformJobName;
    }

    public final String transformJobArn() {
        return this.transformJobArn;
    }

    public final TransformJobStatus transformJobStatus() {
        return TransformJobStatus.fromValue(this.transformJobStatus);
    }

    public final String transformJobStatusAsString() {
        return this.transformJobStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final Integer maxConcurrentTransforms() {
        return this.maxConcurrentTransforms;
    }

    public final ModelClientConfig modelClientConfig() {
        return this.modelClientConfig;
    }

    public final Integer maxPayloadInMB() {
        return this.maxPayloadInMB;
    }

    public final BatchStrategy batchStrategy() {
        return BatchStrategy.fromValue(this.batchStrategy);
    }

    public final String batchStrategyAsString() {
        return this.batchStrategy;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public final TransformInput transformInput() {
        return this.transformInput;
    }

    public final TransformOutput transformOutput() {
        return this.transformOutput;
    }

    public final TransformResources transformResources() {
        return this.transformResources;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant transformStartTime() {
        return this.transformStartTime;
    }

    public final Instant transformEndTime() {
        return this.transformEndTime;
    }

    public final String labelingJobArn() {
        return this.labelingJobArn;
    }

    public final String autoMLJobArn() {
        return this.autoMLJobArn;
    }

    public final DataProcessing dataProcessing() {
        return this.dataProcessing;
    }

    public final ExperimentConfig experimentConfig() {
        return this.experimentConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final BatchDataCaptureConfig dataCaptureConfig() {
        return this.dataCaptureConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentTransforms());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelClientConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPayloadInMB());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transformInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMLJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProcessing());
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCaptureConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformJob)) {
            return false;
        }
        TransformJob other = (TransformJob)obj;
        return Objects.equals(this.transformJobName(), other.transformJobName()) && Objects.equals(this.transformJobArn(), other.transformJobArn()) && Objects.equals(this.transformJobStatusAsString(), other.transformJobStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.maxConcurrentTransforms(), other.maxConcurrentTransforms()) && Objects.equals(this.modelClientConfig(), other.modelClientConfig()) && Objects.equals(this.maxPayloadInMB(), other.maxPayloadInMB()) && Objects.equals(this.batchStrategyAsString(), other.batchStrategyAsString()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.transformInput(), other.transformInput()) && Objects.equals(this.transformOutput(), other.transformOutput()) && Objects.equals(this.transformResources(), other.transformResources()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.transformStartTime(), other.transformStartTime()) && Objects.equals(this.transformEndTime(), other.transformEndTime()) && Objects.equals(this.labelingJobArn(), other.labelingJobArn()) && Objects.equals(this.autoMLJobArn(), other.autoMLJobArn()) && Objects.equals(this.dataProcessing(), other.dataProcessing()) && Objects.equals(this.experimentConfig(), other.experimentConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.dataCaptureConfig(), other.dataCaptureConfig());
    }

    public final String toString() {
        return ToString.builder((String)"TransformJob").add("TransformJobName", (Object)this.transformJobName()).add("TransformJobArn", (Object)this.transformJobArn()).add("TransformJobStatus", (Object)this.transformJobStatusAsString()).add("FailureReason", (Object)this.failureReason()).add("ModelName", (Object)this.modelName()).add("MaxConcurrentTransforms", (Object)this.maxConcurrentTransforms()).add("ModelClientConfig", (Object)this.modelClientConfig()).add("MaxPayloadInMB", (Object)this.maxPayloadInMB()).add("BatchStrategy", (Object)this.batchStrategyAsString()).add("Environment", this.hasEnvironment() ? this.environment() : null).add("TransformInput", (Object)this.transformInput()).add("TransformOutput", (Object)this.transformOutput()).add("TransformResources", (Object)this.transformResources()).add("CreationTime", (Object)this.creationTime()).add("TransformStartTime", (Object)this.transformStartTime()).add("TransformEndTime", (Object)this.transformEndTime()).add("LabelingJobArn", (Object)this.labelingJobArn()).add("AutoMLJobArn", (Object)this.autoMLJobArn()).add("DataProcessing", (Object)this.dataProcessing()).add("ExperimentConfig", (Object)this.experimentConfig()).add("Tags", this.hasTags() ? this.tags() : null).add("DataCaptureConfig", (Object)this.dataCaptureConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformJobName": {
                return Optional.ofNullable(clazz.cast(this.transformJobName()));
            }
            case "TransformJobArn": {
                return Optional.ofNullable(clazz.cast(this.transformJobArn()));
            }
            case "TransformJobStatus": {
                return Optional.ofNullable(clazz.cast(this.transformJobStatusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "MaxConcurrentTransforms": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentTransforms()));
            }
            case "ModelClientConfig": {
                return Optional.ofNullable(clazz.cast(this.modelClientConfig()));
            }
            case "MaxPayloadInMB": {
                return Optional.ofNullable(clazz.cast(this.maxPayloadInMB()));
            }
            case "BatchStrategy": {
                return Optional.ofNullable(clazz.cast(this.batchStrategyAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "TransformInput": {
                return Optional.ofNullable(clazz.cast(this.transformInput()));
            }
            case "TransformOutput": {
                return Optional.ofNullable(clazz.cast(this.transformOutput()));
            }
            case "TransformResources": {
                return Optional.ofNullable(clazz.cast(this.transformResources()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "TransformStartTime": {
                return Optional.ofNullable(clazz.cast(this.transformStartTime()));
            }
            case "TransformEndTime": {
                return Optional.ofNullable(clazz.cast(this.transformEndTime()));
            }
            case "LabelingJobArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobArn()));
            }
            case "AutoMLJobArn": {
                return Optional.ofNullable(clazz.cast(this.autoMLJobArn()));
            }
            case "DataProcessing": {
                return Optional.ofNullable(clazz.cast(this.dataProcessing()));
            }
            case "ExperimentConfig": {
                return Optional.ofNullable(clazz.cast(this.experimentConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "DataCaptureConfig": {
                return Optional.ofNullable(clazz.cast(this.dataCaptureConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformJob, T> g) {
        return obj -> g.apply((TransformJob)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transformJobName;
        private String transformJobArn;
        private String transformJobStatus;
        private String failureReason;
        private String modelName;
        private Integer maxConcurrentTransforms;
        private ModelClientConfig modelClientConfig;
        private Integer maxPayloadInMB;
        private String batchStrategy;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();
        private TransformInput transformInput;
        private TransformOutput transformOutput;
        private TransformResources transformResources;
        private Instant creationTime;
        private Instant transformStartTime;
        private Instant transformEndTime;
        private String labelingJobArn;
        private String autoMLJobArn;
        private DataProcessing dataProcessing;
        private ExperimentConfig experimentConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private BatchDataCaptureConfig dataCaptureConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TransformJob model) {
            this.transformJobName(model.transformJobName);
            this.transformJobArn(model.transformJobArn);
            this.transformJobStatus(model.transformJobStatus);
            this.failureReason(model.failureReason);
            this.modelName(model.modelName);
            this.maxConcurrentTransforms(model.maxConcurrentTransforms);
            this.modelClientConfig(model.modelClientConfig);
            this.maxPayloadInMB(model.maxPayloadInMB);
            this.batchStrategy(model.batchStrategy);
            this.environment(model.environment);
            this.transformInput(model.transformInput);
            this.transformOutput(model.transformOutput);
            this.transformResources(model.transformResources);
            this.creationTime(model.creationTime);
            this.transformStartTime(model.transformStartTime);
            this.transformEndTime(model.transformEndTime);
            this.labelingJobArn(model.labelingJobArn);
            this.autoMLJobArn(model.autoMLJobArn);
            this.dataProcessing(model.dataProcessing);
            this.experimentConfig(model.experimentConfig);
            this.tags(model.tags);
            this.dataCaptureConfig(model.dataCaptureConfig);
        }

        public final String getTransformJobName() {
            return this.transformJobName;
        }

        public final void setTransformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
        }

        @Override
        public final Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public final String getTransformJobArn() {
            return this.transformJobArn;
        }

        public final void setTransformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
        }

        @Override
        public final Builder transformJobArn(String transformJobArn) {
            this.transformJobArn = transformJobArn;
            return this;
        }

        public final String getTransformJobStatus() {
            return this.transformJobStatus;
        }

        public final void setTransformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
        }

        @Override
        public final Builder transformJobStatus(String transformJobStatus) {
            this.transformJobStatus = transformJobStatus;
            return this;
        }

        @Override
        public final Builder transformJobStatus(TransformJobStatus transformJobStatus) {
            this.transformJobStatus(transformJobStatus == null ? null : transformJobStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final Integer getMaxConcurrentTransforms() {
            return this.maxConcurrentTransforms;
        }

        public final void setMaxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
        }

        @Override
        public final Builder maxConcurrentTransforms(Integer maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public final ModelClientConfig.Builder getModelClientConfig() {
            return this.modelClientConfig != null ? this.modelClientConfig.toBuilder() : null;
        }

        public final void setModelClientConfig(ModelClientConfig.BuilderImpl modelClientConfig) {
            this.modelClientConfig = modelClientConfig != null ? modelClientConfig.build() : null;
        }

        @Override
        public final Builder modelClientConfig(ModelClientConfig modelClientConfig) {
            this.modelClientConfig = modelClientConfig;
            return this;
        }

        public final Integer getMaxPayloadInMB() {
            return this.maxPayloadInMB;
        }

        public final void setMaxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
        }

        @Override
        public final Builder maxPayloadInMB(Integer maxPayloadInMB) {
            this.maxPayloadInMB = maxPayloadInMB;
            return this;
        }

        public final String getBatchStrategy() {
            return this.batchStrategy;
        }

        public final void setBatchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
        }

        @Override
        public final Builder batchStrategy(String batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        @Override
        public final Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy(batchStrategy == null ? null : batchStrategy.toString());
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = TransformEnvironmentMapCopier.copy(environment);
            return this;
        }

        public final TransformInput.Builder getTransformInput() {
            return this.transformInput != null ? this.transformInput.toBuilder() : null;
        }

        public final void setTransformInput(TransformInput.BuilderImpl transformInput) {
            this.transformInput = transformInput != null ? transformInput.build() : null;
        }

        @Override
        public final Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public final TransformOutput.Builder getTransformOutput() {
            return this.transformOutput != null ? this.transformOutput.toBuilder() : null;
        }

        public final void setTransformOutput(TransformOutput.BuilderImpl transformOutput) {
            this.transformOutput = transformOutput != null ? transformOutput.build() : null;
        }

        @Override
        public final Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public final TransformResources.Builder getTransformResources() {
            return this.transformResources != null ? this.transformResources.toBuilder() : null;
        }

        public final void setTransformResources(TransformResources.BuilderImpl transformResources) {
            this.transformResources = transformResources != null ? transformResources.build() : null;
        }

        @Override
        public final Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getTransformStartTime() {
            return this.transformStartTime;
        }

        public final void setTransformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
        }

        @Override
        public final Builder transformStartTime(Instant transformStartTime) {
            this.transformStartTime = transformStartTime;
            return this;
        }

        public final Instant getTransformEndTime() {
            return this.transformEndTime;
        }

        public final void setTransformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
        }

        @Override
        public final Builder transformEndTime(Instant transformEndTime) {
            this.transformEndTime = transformEndTime;
            return this;
        }

        public final String getLabelingJobArn() {
            return this.labelingJobArn;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final String getAutoMLJobArn() {
            return this.autoMLJobArn;
        }

        public final void setAutoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
        }

        @Override
        public final Builder autoMLJobArn(String autoMLJobArn) {
            this.autoMLJobArn = autoMLJobArn;
            return this;
        }

        public final DataProcessing.Builder getDataProcessing() {
            return this.dataProcessing != null ? this.dataProcessing.toBuilder() : null;
        }

        public final void setDataProcessing(DataProcessing.BuilderImpl dataProcessing) {
            this.dataProcessing = dataProcessing != null ? dataProcessing.build() : null;
        }

        @Override
        public final Builder dataProcessing(DataProcessing dataProcessing) {
            this.dataProcessing = dataProcessing;
            return this;
        }

        public final ExperimentConfig.Builder getExperimentConfig() {
            return this.experimentConfig != null ? this.experimentConfig.toBuilder() : null;
        }

        public final void setExperimentConfig(ExperimentConfig.BuilderImpl experimentConfig) {
            this.experimentConfig = experimentConfig != null ? experimentConfig.build() : null;
        }

        @Override
        public final Builder experimentConfig(ExperimentConfig experimentConfig) {
            this.experimentConfig = experimentConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final BatchDataCaptureConfig.Builder getDataCaptureConfig() {
            return this.dataCaptureConfig != null ? this.dataCaptureConfig.toBuilder() : null;
        }

        public final void setDataCaptureConfig(BatchDataCaptureConfig.BuilderImpl dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig != null ? dataCaptureConfig.build() : null;
        }

        @Override
        public final Builder dataCaptureConfig(BatchDataCaptureConfig dataCaptureConfig) {
            this.dataCaptureConfig = dataCaptureConfig;
            return this;
        }

        public TransformJob build() {
            return new TransformJob(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransformJob> {
        public Builder transformJobName(String var1);

        public Builder transformJobArn(String var1);

        public Builder transformJobStatus(String var1);

        public Builder transformJobStatus(TransformJobStatus var1);

        public Builder failureReason(String var1);

        public Builder modelName(String var1);

        public Builder maxConcurrentTransforms(Integer var1);

        public Builder modelClientConfig(ModelClientConfig var1);

        default public Builder modelClientConfig(Consumer<ModelClientConfig.Builder> modelClientConfig) {
            return this.modelClientConfig((ModelClientConfig)((ModelClientConfig.Builder)ModelClientConfig.builder().applyMutation(modelClientConfig)).build());
        }

        public Builder maxPayloadInMB(Integer var1);

        public Builder batchStrategy(String var1);

        public Builder batchStrategy(BatchStrategy var1);

        public Builder environment(Map<String, String> var1);

        public Builder transformInput(TransformInput var1);

        default public Builder transformInput(Consumer<TransformInput.Builder> transformInput) {
            return this.transformInput((TransformInput)((TransformInput.Builder)TransformInput.builder().applyMutation(transformInput)).build());
        }

        public Builder transformOutput(TransformOutput var1);

        default public Builder transformOutput(Consumer<TransformOutput.Builder> transformOutput) {
            return this.transformOutput((TransformOutput)((TransformOutput.Builder)TransformOutput.builder().applyMutation(transformOutput)).build());
        }

        public Builder transformResources(TransformResources var1);

        default public Builder transformResources(Consumer<TransformResources.Builder> transformResources) {
            return this.transformResources((TransformResources)((TransformResources.Builder)TransformResources.builder().applyMutation(transformResources)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder transformStartTime(Instant var1);

        public Builder transformEndTime(Instant var1);

        public Builder labelingJobArn(String var1);

        public Builder autoMLJobArn(String var1);

        public Builder dataProcessing(DataProcessing var1);

        default public Builder dataProcessing(Consumer<DataProcessing.Builder> dataProcessing) {
            return this.dataProcessing((DataProcessing)((DataProcessing.Builder)DataProcessing.builder().applyMutation(dataProcessing)).build());
        }

        public Builder experimentConfig(ExperimentConfig var1);

        default public Builder experimentConfig(Consumer<ExperimentConfig.Builder> experimentConfig) {
            return this.experimentConfig((ExperimentConfig)((ExperimentConfig.Builder)ExperimentConfig.builder().applyMutation(experimentConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder dataCaptureConfig(BatchDataCaptureConfig var1);

        default public Builder dataCaptureConfig(Consumer<BatchDataCaptureConfig.Builder> dataCaptureConfig) {
            return this.dataCaptureConfig((BatchDataCaptureConfig)((BatchDataCaptureConfig.Builder)BatchDataCaptureConfig.builder().applyMutation(dataCaptureConfig)).build());
        }
    }
}

