/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListStudioLifecycleConfigsResponse;
import software.amazon.awssdk.services.sagemaker.model.StudioLifecycleConfigDetails;

public class ListStudioLifecycleConfigsPublisher
implements SdkPublisher<ListStudioLifecycleConfigsResponse> {
    private final SageMakerAsyncClient client;
    private final ListStudioLifecycleConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListStudioLifecycleConfigsPublisher(SageMakerAsyncClient client, ListStudioLifecycleConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListStudioLifecycleConfigsPublisher(SageMakerAsyncClient client, ListStudioLifecycleConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListStudioLifecycleConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListStudioLifecycleConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<StudioLifecycleConfigDetails> studioLifecycleConfigs() {
        Function<ListStudioLifecycleConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.studioLifecycleConfigs() != null) {
                return response.studioLifecycleConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListStudioLifecycleConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListStudioLifecycleConfigsResponseFetcher
    implements AsyncPageFetcher<ListStudioLifecycleConfigsResponse> {
        private ListStudioLifecycleConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListStudioLifecycleConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListStudioLifecycleConfigsResponse> nextPage(ListStudioLifecycleConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListStudioLifecycleConfigsPublisher.this.client.listStudioLifecycleConfigs(ListStudioLifecycleConfigsPublisher.this.firstRequest);
            }
            return ListStudioLifecycleConfigsPublisher.this.client.listStudioLifecycleConfigs((ListStudioLifecycleConfigsRequest)((Object)ListStudioLifecycleConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

