/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.LogicalOperator;
import software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilter;
import software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFiltersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyFilters> {
    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalOperator").getter(PropertyFilters.getter(PropertyFilters::logicalOperatorAsString)).setter(PropertyFilters.setter(Builder::logicalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()}).build();
    private static final SdkField<List<PropertyFilter>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Properties").getter(PropertyFilters.getter(PropertyFilters::properties)).setter(PropertyFilters.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Properties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_OPERATOR_FIELD, PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String logicalOperator;
    private final List<PropertyFilter> properties;

    private PropertyFilters(BuilderImpl builder) {
        this.logicalOperator = builder.logicalOperator;
        this.properties = builder.properties;
    }

    public final LogicalOperator logicalOperator() {
        return LogicalOperator.fromValue(this.logicalOperator);
    }

    public final String logicalOperatorAsString() {
        return this.logicalOperator;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructList);
    }

    public final List<PropertyFilter> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyFilters)) {
            return false;
        }
        PropertyFilters other = (PropertyFilters)obj;
        return Objects.equals(this.logicalOperatorAsString(), other.logicalOperatorAsString()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyFilters").add("LogicalOperator", (Object)this.logicalOperatorAsString()).add("Properties", this.hasProperties() ? this.properties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalOperator": {
                return Optional.ofNullable(clazz.cast(this.logicalOperatorAsString()));
            }
            case "Properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PropertyFilters, T> g) {
        return obj -> g.apply((PropertyFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalOperator;
        private List<PropertyFilter> properties = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyFilters model) {
            this.logicalOperator(model.logicalOperator);
            this.properties(model.properties);
        }

        public final String getLogicalOperator() {
            return this.logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(LogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public final List<PropertyFilter.Builder> getProperties() {
            List<PropertyFilter.Builder> result = PropertyFiltersListCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProperties(Collection<PropertyFilter.BuilderImpl> properties) {
            this.properties = PropertyFiltersListCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Collection<PropertyFilter> properties) {
            this.properties = PropertyFiltersListCopier.copy(properties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(PropertyFilter ... properties) {
            this.properties(Arrays.asList(properties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder properties(Consumer<PropertyFilter.Builder> ... properties) {
            this.properties(Stream.of(properties).map(c -> (PropertyFilter)((PropertyFilter.Builder)PropertyFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PropertyFilters build() {
            return new PropertyFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyFilters> {
        public Builder logicalOperator(String var1);

        public Builder logicalOperator(LogicalOperator var1);

        public Builder properties(Collection<PropertyFilter> var1);

        public Builder properties(PropertyFilter ... var1);

        public Builder properties(Consumer<PropertyFilter.Builder> ... var1);
    }
}

