/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakergeospatial.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemakergeospatial.model.AreaOfInterest;
import software.amazon.awssdk.services.sagemakergeospatial.model.PropertyFilters;
import software.amazon.awssdk.services.sagemakergeospatial.model.StringListInputCopier;
import software.amazon.awssdk.services.sagemakergeospatial.model.TimeRangeFilterInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RasterDataCollectionQueryWithBandFilterInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RasterDataCollectionQueryWithBandFilterInput> {
    private static final SdkField<AreaOfInterest> AREA_OF_INTEREST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AreaOfInterest").getter(RasterDataCollectionQueryWithBandFilterInput.getter(RasterDataCollectionQueryWithBandFilterInput::areaOfInterest)).setter(RasterDataCollectionQueryWithBandFilterInput.setter(Builder::areaOfInterest)).constructor(AreaOfInterest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AreaOfInterest").build()}).build();
    private static final SdkField<List<String>> BAND_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BandFilter").getter(RasterDataCollectionQueryWithBandFilterInput.getter(RasterDataCollectionQueryWithBandFilterInput::bandFilter)).setter(RasterDataCollectionQueryWithBandFilterInput.setter(Builder::bandFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BandFilter").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<PropertyFilters> PROPERTY_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PropertyFilters").getter(RasterDataCollectionQueryWithBandFilterInput.getter(RasterDataCollectionQueryWithBandFilterInput::propertyFilters)).setter(RasterDataCollectionQueryWithBandFilterInput.setter(Builder::propertyFilters)).constructor(PropertyFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropertyFilters").build()}).build();
    private static final SdkField<TimeRangeFilterInput> TIME_RANGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimeRangeFilter").getter(RasterDataCollectionQueryWithBandFilterInput.getter(RasterDataCollectionQueryWithBandFilterInput::timeRangeFilter)).setter(RasterDataCollectionQueryWithBandFilterInput.setter(Builder::timeRangeFilter)).constructor(TimeRangeFilterInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeRangeFilter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AREA_OF_INTEREST_FIELD, BAND_FILTER_FIELD, PROPERTY_FILTERS_FIELD, TIME_RANGE_FILTER_FIELD));
    private static final long serialVersionUID = 1L;
    private final AreaOfInterest areaOfInterest;
    private final List<String> bandFilter;
    private final PropertyFilters propertyFilters;
    private final TimeRangeFilterInput timeRangeFilter;

    private RasterDataCollectionQueryWithBandFilterInput(BuilderImpl builder) {
        this.areaOfInterest = builder.areaOfInterest;
        this.bandFilter = builder.bandFilter;
        this.propertyFilters = builder.propertyFilters;
        this.timeRangeFilter = builder.timeRangeFilter;
    }

    public final AreaOfInterest areaOfInterest() {
        return this.areaOfInterest;
    }

    public final boolean hasBandFilter() {
        return this.bandFilter != null && !(this.bandFilter instanceof SdkAutoConstructList);
    }

    public final List<String> bandFilter() {
        return this.bandFilter;
    }

    public final PropertyFilters propertyFilters() {
        return this.propertyFilters;
    }

    public final TimeRangeFilterInput timeRangeFilter() {
        return this.timeRangeFilter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.areaOfInterest());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBandFilter() ? this.bandFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeRangeFilter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RasterDataCollectionQueryWithBandFilterInput)) {
            return false;
        }
        RasterDataCollectionQueryWithBandFilterInput other = (RasterDataCollectionQueryWithBandFilterInput)obj;
        return Objects.equals(this.areaOfInterest(), other.areaOfInterest()) && this.hasBandFilter() == other.hasBandFilter() && Objects.equals(this.bandFilter(), other.bandFilter()) && Objects.equals(this.propertyFilters(), other.propertyFilters()) && Objects.equals(this.timeRangeFilter(), other.timeRangeFilter());
    }

    public final String toString() {
        return ToString.builder((String)"RasterDataCollectionQueryWithBandFilterInput").add("AreaOfInterest", (Object)this.areaOfInterest()).add("BandFilter", this.hasBandFilter() ? this.bandFilter() : null).add("PropertyFilters", (Object)this.propertyFilters()).add("TimeRangeFilter", (Object)(this.timeRangeFilter() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AreaOfInterest": {
                return Optional.ofNullable(clazz.cast(this.areaOfInterest()));
            }
            case "BandFilter": {
                return Optional.ofNullable(clazz.cast(this.bandFilter()));
            }
            case "PropertyFilters": {
                return Optional.ofNullable(clazz.cast(this.propertyFilters()));
            }
            case "TimeRangeFilter": {
                return Optional.ofNullable(clazz.cast(this.timeRangeFilter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RasterDataCollectionQueryWithBandFilterInput, T> g) {
        return obj -> g.apply((RasterDataCollectionQueryWithBandFilterInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AreaOfInterest areaOfInterest;
        private List<String> bandFilter = DefaultSdkAutoConstructList.getInstance();
        private PropertyFilters propertyFilters;
        private TimeRangeFilterInput timeRangeFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(RasterDataCollectionQueryWithBandFilterInput model) {
            this.areaOfInterest(model.areaOfInterest);
            this.bandFilter(model.bandFilter);
            this.propertyFilters(model.propertyFilters);
            this.timeRangeFilter(model.timeRangeFilter);
        }

        public final AreaOfInterest.Builder getAreaOfInterest() {
            return this.areaOfInterest != null ? this.areaOfInterest.toBuilder() : null;
        }

        public final void setAreaOfInterest(AreaOfInterest.BuilderImpl areaOfInterest) {
            this.areaOfInterest = areaOfInterest != null ? areaOfInterest.build() : null;
        }

        @Override
        public final Builder areaOfInterest(AreaOfInterest areaOfInterest) {
            this.areaOfInterest = areaOfInterest;
            return this;
        }

        public final Collection<String> getBandFilter() {
            if (this.bandFilter instanceof SdkAutoConstructList) {
                return null;
            }
            return this.bandFilter;
        }

        public final void setBandFilter(Collection<String> bandFilter) {
            this.bandFilter = StringListInputCopier.copy(bandFilter);
        }

        @Override
        public final Builder bandFilter(Collection<String> bandFilter) {
            this.bandFilter = StringListInputCopier.copy(bandFilter);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bandFilter(String ... bandFilter) {
            this.bandFilter(Arrays.asList(bandFilter));
            return this;
        }

        public final PropertyFilters.Builder getPropertyFilters() {
            return this.propertyFilters != null ? this.propertyFilters.toBuilder() : null;
        }

        public final void setPropertyFilters(PropertyFilters.BuilderImpl propertyFilters) {
            this.propertyFilters = propertyFilters != null ? propertyFilters.build() : null;
        }

        @Override
        public final Builder propertyFilters(PropertyFilters propertyFilters) {
            this.propertyFilters = propertyFilters;
            return this;
        }

        public final TimeRangeFilterInput.Builder getTimeRangeFilter() {
            return this.timeRangeFilter != null ? this.timeRangeFilter.toBuilder() : null;
        }

        public final void setTimeRangeFilter(TimeRangeFilterInput.BuilderImpl timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter != null ? timeRangeFilter.build() : null;
        }

        @Override
        public final Builder timeRangeFilter(TimeRangeFilterInput timeRangeFilter) {
            this.timeRangeFilter = timeRangeFilter;
            return this;
        }

        public RasterDataCollectionQueryWithBandFilterInput build() {
            return new RasterDataCollectionQueryWithBandFilterInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RasterDataCollectionQueryWithBandFilterInput> {
        public Builder areaOfInterest(AreaOfInterest var1);

        default public Builder areaOfInterest(Consumer<AreaOfInterest.Builder> areaOfInterest) {
            return this.areaOfInterest((AreaOfInterest)((AreaOfInterest.Builder)AreaOfInterest.builder().applyMutation(areaOfInterest)).build());
        }

        public Builder bandFilter(Collection<String> var1);

        public Builder bandFilter(String ... var1);

        public Builder propertyFilters(PropertyFilters var1);

        default public Builder propertyFilters(Consumer<PropertyFilters.Builder> propertyFilters) {
            return this.propertyFilters((PropertyFilters)((PropertyFilters.Builder)PropertyFilters.builder().applyMutation(propertyFilters)).build());
        }

        public Builder timeRangeFilter(TimeRangeFilterInput var1);

        default public Builder timeRangeFilter(Consumer<TimeRangeFilterInput.Builder> timeRangeFilter) {
            return this.timeRangeFilter((TimeRangeFilterInput)((TimeRangeFilterInput.Builder)TimeRangeFilterInput.builder().applyMutation(timeRangeFilter)).build());
        }
    }
}

