/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemakerruntime;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sagemakerruntime.DefaultSageMakerRuntimeAsyncClient;
import software.amazon.awssdk.services.sagemakerruntime.DefaultSageMakerRuntimeBaseClientBuilder;
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeAsyncClient;
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeAsyncClientBuilder;
import software.amazon.awssdk.services.sagemakerruntime.SageMakerRuntimeServiceClientConfiguration;
import software.amazon.awssdk.services.sagemakerruntime.endpoints.SageMakerRuntimeEndpointProvider;

@SdkInternalApi
final class DefaultSageMakerRuntimeAsyncClientBuilder
extends DefaultSageMakerRuntimeBaseClientBuilder<SageMakerRuntimeAsyncClientBuilder, SageMakerRuntimeAsyncClient>
implements SageMakerRuntimeAsyncClientBuilder {
    DefaultSageMakerRuntimeAsyncClientBuilder() {
    }

    @Override
    public DefaultSageMakerRuntimeAsyncClientBuilder endpointProvider(SageMakerRuntimeEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SageMakerRuntimeAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultSageMakerRuntimeAsyncClientBuilder.validateClientOptions(clientConfiguration);
        SageMakerRuntimeServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSageMakerRuntimeAsyncClient client = new DefaultSageMakerRuntimeAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SageMakerRuntimeServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SageMakerRuntimeServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

