/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.AwsKinesisStreamStreamEncryptionDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsKinesisStreamDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsKinesisStreamDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsKinesisStreamDetails.getter(AwsKinesisStreamDetails::name)).setter(AwsKinesisStreamDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsKinesisStreamDetails.getter(AwsKinesisStreamDetails::arn)).setter(AwsKinesisStreamDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<AwsKinesisStreamStreamEncryptionDetails> STREAM_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StreamEncryption").getter(AwsKinesisStreamDetails.getter(AwsKinesisStreamDetails::streamEncryption)).setter(AwsKinesisStreamDetails.setter(Builder::streamEncryption)).constructor(AwsKinesisStreamStreamEncryptionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEncryption").build()}).build();
    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ShardCount").getter(AwsKinesisStreamDetails.getter(AwsKinesisStreamDetails::shardCount)).setter(AwsKinesisStreamDetails.setter(Builder::shardCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardCount").build()}).build();
    private static final SdkField<Integer> RETENTION_PERIOD_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("RetentionPeriodHours").getter(AwsKinesisStreamDetails.getter(AwsKinesisStreamDetails::retentionPeriodHours)).setter(AwsKinesisStreamDetails.setter(Builder::retentionPeriodHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD, STREAM_ENCRYPTION_FIELD, SHARD_COUNT_FIELD, RETENTION_PERIOD_HOURS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String arn;
    private final AwsKinesisStreamStreamEncryptionDetails streamEncryption;
    private final Integer shardCount;
    private final Integer retentionPeriodHours;

    private AwsKinesisStreamDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.streamEncryption = builder.streamEncryption;
        this.shardCount = builder.shardCount;
        this.retentionPeriodHours = builder.retentionPeriodHours;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final AwsKinesisStreamStreamEncryptionDetails streamEncryption() {
        return this.streamEncryption;
    }

    public final Integer shardCount() {
        return this.shardCount;
    }

    public final Integer retentionPeriodHours() {
        return this.retentionPeriodHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriodHours());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsKinesisStreamDetails)) {
            return false;
        }
        AwsKinesisStreamDetails other = (AwsKinesisStreamDetails)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.streamEncryption(), other.streamEncryption()) && Objects.equals(this.shardCount(), other.shardCount()) && Objects.equals(this.retentionPeriodHours(), other.retentionPeriodHours());
    }

    public final String toString() {
        return ToString.builder((String)"AwsKinesisStreamDetails").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("StreamEncryption", (Object)this.streamEncryption()).add("ShardCount", (Object)this.shardCount()).add("RetentionPeriodHours", (Object)this.retentionPeriodHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "StreamEncryption": {
                return Optional.ofNullable(clazz.cast(this.streamEncryption()));
            }
            case "ShardCount": {
                return Optional.ofNullable(clazz.cast(this.shardCount()));
            }
            case "RetentionPeriodHours": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriodHours()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsKinesisStreamDetails, T> g) {
        return obj -> g.apply((AwsKinesisStreamDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private AwsKinesisStreamStreamEncryptionDetails streamEncryption;
        private Integer shardCount;
        private Integer retentionPeriodHours;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsKinesisStreamDetails model) {
            this.name(model.name);
            this.arn(model.arn);
            this.streamEncryption(model.streamEncryption);
            this.shardCount(model.shardCount);
            this.retentionPeriodHours(model.retentionPeriodHours);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AwsKinesisStreamStreamEncryptionDetails.Builder getStreamEncryption() {
            return this.streamEncryption != null ? this.streamEncryption.toBuilder() : null;
        }

        public final void setStreamEncryption(AwsKinesisStreamStreamEncryptionDetails.BuilderImpl streamEncryption) {
            this.streamEncryption = streamEncryption != null ? streamEncryption.build() : null;
        }

        @Override
        public final Builder streamEncryption(AwsKinesisStreamStreamEncryptionDetails streamEncryption) {
            this.streamEncryption = streamEncryption;
            return this;
        }

        public final Integer getShardCount() {
            return this.shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final Integer getRetentionPeriodHours() {
            return this.retentionPeriodHours;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        public AwsKinesisStreamDetails build() {
            return new AwsKinesisStreamDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsKinesisStreamDetails> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder streamEncryption(AwsKinesisStreamStreamEncryptionDetails var1);

        default public Builder streamEncryption(Consumer<AwsKinesisStreamStreamEncryptionDetails.Builder> streamEncryption) {
            return this.streamEncryption((AwsKinesisStreamStreamEncryptionDetails)((AwsKinesisStreamStreamEncryptionDetails.Builder)AwsKinesisStreamStreamEncryptionDetails.builder().applyMutation(streamEncryption)).build());
        }

        public Builder shardCount(Integer var1);

        public Builder retentionPeriodHours(Integer var1);
    }
}

