/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetail;
import software.amazon.awssdk.services.securityhub.model.StandardsControlAssociationDetailsCopier;
import software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociation;
import software.amazon.awssdk.services.securityhub.model.UnprocessedStandardsControlAssociationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetStandardsControlAssociationsResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, BatchGetStandardsControlAssociationsResponse> {
    private static final SdkField<List<StandardsControlAssociationDetail>> STANDARDS_CONTROL_ASSOCIATION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StandardsControlAssociationDetails").getter(BatchGetStandardsControlAssociationsResponse.getter(BatchGetStandardsControlAssociationsResponse::standardsControlAssociationDetails)).setter(BatchGetStandardsControlAssociationsResponse.setter(Builder::standardsControlAssociationDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardsControlAssociationDetails").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StandardsControlAssociationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedStandardsControlAssociation>> UNPROCESSED_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAssociations").getter(BatchGetStandardsControlAssociationsResponse.getter(BatchGetStandardsControlAssociationsResponse::unprocessedAssociations)).setter(BatchGetStandardsControlAssociationsResponse.setter(Builder::unprocessedAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedStandardsControlAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARDS_CONTROL_ASSOCIATION_DETAILS_FIELD, UNPROCESSED_ASSOCIATIONS_FIELD));
    private final List<StandardsControlAssociationDetail> standardsControlAssociationDetails;
    private final List<UnprocessedStandardsControlAssociation> unprocessedAssociations;

    private BatchGetStandardsControlAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.standardsControlAssociationDetails = builder.standardsControlAssociationDetails;
        this.unprocessedAssociations = builder.unprocessedAssociations;
    }

    public final boolean hasStandardsControlAssociationDetails() {
        return this.standardsControlAssociationDetails != null && !(this.standardsControlAssociationDetails instanceof SdkAutoConstructList);
    }

    public final List<StandardsControlAssociationDetail> standardsControlAssociationDetails() {
        return this.standardsControlAssociationDetails;
    }

    public final boolean hasUnprocessedAssociations() {
        return this.unprocessedAssociations != null && !(this.unprocessedAssociations instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedStandardsControlAssociation> unprocessedAssociations() {
        return this.unprocessedAssociations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStandardsControlAssociationDetails() ? this.standardsControlAssociationDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAssociations() ? this.unprocessedAssociations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetStandardsControlAssociationsResponse)) {
            return false;
        }
        BatchGetStandardsControlAssociationsResponse other = (BatchGetStandardsControlAssociationsResponse)((Object)obj);
        return this.hasStandardsControlAssociationDetails() == other.hasStandardsControlAssociationDetails() && Objects.equals(this.standardsControlAssociationDetails(), other.standardsControlAssociationDetails()) && this.hasUnprocessedAssociations() == other.hasUnprocessedAssociations() && Objects.equals(this.unprocessedAssociations(), other.unprocessedAssociations());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetStandardsControlAssociationsResponse").add("StandardsControlAssociationDetails", this.hasStandardsControlAssociationDetails() ? this.standardsControlAssociationDetails() : null).add("UnprocessedAssociations", this.hasUnprocessedAssociations() ? this.unprocessedAssociations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StandardsControlAssociationDetails": {
                return Optional.ofNullable(clazz.cast(this.standardsControlAssociationDetails()));
            }
            case "UnprocessedAssociations": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAssociations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetStandardsControlAssociationsResponse, T> g) {
        return obj -> g.apply((BatchGetStandardsControlAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<StandardsControlAssociationDetail> standardsControlAssociationDetails = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedStandardsControlAssociation> unprocessedAssociations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetStandardsControlAssociationsResponse model) {
            super(model);
            this.standardsControlAssociationDetails(model.standardsControlAssociationDetails);
            this.unprocessedAssociations(model.unprocessedAssociations);
        }

        public final List<StandardsControlAssociationDetail.Builder> getStandardsControlAssociationDetails() {
            List<StandardsControlAssociationDetail.Builder> result = StandardsControlAssociationDetailsCopier.copyToBuilder(this.standardsControlAssociationDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStandardsControlAssociationDetails(Collection<StandardsControlAssociationDetail.BuilderImpl> standardsControlAssociationDetails) {
            this.standardsControlAssociationDetails = StandardsControlAssociationDetailsCopier.copyFromBuilder(standardsControlAssociationDetails);
        }

        @Override
        public final Builder standardsControlAssociationDetails(Collection<StandardsControlAssociationDetail> standardsControlAssociationDetails) {
            this.standardsControlAssociationDetails = StandardsControlAssociationDetailsCopier.copy(standardsControlAssociationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationDetails(StandardsControlAssociationDetail ... standardsControlAssociationDetails) {
            this.standardsControlAssociationDetails(Arrays.asList(standardsControlAssociationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder standardsControlAssociationDetails(Consumer<StandardsControlAssociationDetail.Builder> ... standardsControlAssociationDetails) {
            this.standardsControlAssociationDetails(Stream.of(standardsControlAssociationDetails).map(c -> (StandardsControlAssociationDetail)((StandardsControlAssociationDetail.Builder)StandardsControlAssociationDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedStandardsControlAssociation.Builder> getUnprocessedAssociations() {
            List<UnprocessedStandardsControlAssociation.Builder> result = UnprocessedStandardsControlAssociationsCopier.copyToBuilder(this.unprocessedAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAssociations(Collection<UnprocessedStandardsControlAssociation.BuilderImpl> unprocessedAssociations) {
            this.unprocessedAssociations = UnprocessedStandardsControlAssociationsCopier.copyFromBuilder(unprocessedAssociations);
        }

        @Override
        public final Builder unprocessedAssociations(Collection<UnprocessedStandardsControlAssociation> unprocessedAssociations) {
            this.unprocessedAssociations = UnprocessedStandardsControlAssociationsCopier.copy(unprocessedAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAssociations(UnprocessedStandardsControlAssociation ... unprocessedAssociations) {
            this.unprocessedAssociations(Arrays.asList(unprocessedAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAssociations(Consumer<UnprocessedStandardsControlAssociation.Builder> ... unprocessedAssociations) {
            this.unprocessedAssociations(Stream.of(unprocessedAssociations).map(c -> (UnprocessedStandardsControlAssociation)((UnprocessedStandardsControlAssociation.Builder)UnprocessedStandardsControlAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetStandardsControlAssociationsResponse build() {
            return new BatchGetStandardsControlAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetStandardsControlAssociationsResponse> {
        public Builder standardsControlAssociationDetails(Collection<StandardsControlAssociationDetail> var1);

        public Builder standardsControlAssociationDetails(StandardsControlAssociationDetail ... var1);

        public Builder standardsControlAssociationDetails(Consumer<StandardsControlAssociationDetail.Builder> ... var1);

        public Builder unprocessedAssociations(Collection<UnprocessedStandardsControlAssociation> var1);

        public Builder unprocessedAssociations(UnprocessedStandardsControlAssociation ... var1);

        public Builder unprocessedAssociations(Consumer<UnprocessedStandardsControlAssociation.Builder> ... var1);
    }
}

