/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securitylake.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HttpMethod {
    POST("POST"),
    PUT("PUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HttpMethod> VALUE_MAP;
    private final String value;

    private HttpMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HttpMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HttpMethod> knownValues() {
        EnumSet<HttpMethod> knownValues = EnumSet.allOf(HttpMethod.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HttpMethod.class, HttpMethod::toString);
    }
}

