/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.DefaultServiceCatalogBaseClientBuilder;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClientBuilder;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogServiceClientConfiguration;
import software.amazon.awssdk.services.servicecatalog.endpoints.ServiceCatalogEndpointProvider;

@SdkInternalApi
final class DefaultServiceCatalogAsyncClientBuilder
extends DefaultServiceCatalogBaseClientBuilder<ServiceCatalogAsyncClientBuilder, ServiceCatalogAsyncClient>
implements ServiceCatalogAsyncClientBuilder {
    DefaultServiceCatalogAsyncClientBuilder() {
    }

    @Override
    public DefaultServiceCatalogAsyncClientBuilder endpointProvider(ServiceCatalogEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceCatalogAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultServiceCatalogAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ServiceCatalogServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultServiceCatalogAsyncClient client = new DefaultServiceCatalogAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ServiceCatalogServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ServiceCatalogServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

