/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummariesCopier;
import software.amazon.awssdk.services.servicecatalog.model.LaunchPathSummary;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLaunchPathsResponse
extends ServiceCatalogResponse
implements ToCopyableBuilder<Builder, ListLaunchPathsResponse> {
    private static final SdkField<List<LaunchPathSummary>> LAUNCH_PATH_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LaunchPathSummaries").getter(ListLaunchPathsResponse.getter(ListLaunchPathsResponse::launchPathSummaries)).setter(ListLaunchPathsResponse.setter(Builder::launchPathSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPathSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchPathSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(ListLaunchPathsResponse.getter(ListLaunchPathsResponse::nextPageToken)).setter(ListLaunchPathsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_PATH_SUMMARIES_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<LaunchPathSummary> launchPathSummaries;
    private final String nextPageToken;

    private ListLaunchPathsResponse(BuilderImpl builder) {
        super(builder);
        this.launchPathSummaries = builder.launchPathSummaries;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasLaunchPathSummaries() {
        return this.launchPathSummaries != null && !(this.launchPathSummaries instanceof SdkAutoConstructList);
    }

    public final List<LaunchPathSummary> launchPathSummaries() {
        return this.launchPathSummaries;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchPathSummaries() ? this.launchPathSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLaunchPathsResponse)) {
            return false;
        }
        ListLaunchPathsResponse other = (ListLaunchPathsResponse)((Object)obj);
        return this.hasLaunchPathSummaries() == other.hasLaunchPathSummaries() && Objects.equals(this.launchPathSummaries(), other.launchPathSummaries()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLaunchPathsResponse").add("LaunchPathSummaries", this.hasLaunchPathSummaries() ? this.launchPathSummaries() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchPathSummaries": {
                return Optional.ofNullable(clazz.cast(this.launchPathSummaries()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLaunchPathsResponse, T> g) {
        return obj -> g.apply((ListLaunchPathsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogResponse.BuilderImpl
    implements Builder {
        private List<LaunchPathSummary> launchPathSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLaunchPathsResponse model) {
            super(model);
            this.launchPathSummaries(model.launchPathSummaries);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<LaunchPathSummary.Builder> getLaunchPathSummaries() {
            List<LaunchPathSummary.Builder> result = LaunchPathSummariesCopier.copyToBuilder(this.launchPathSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLaunchPathSummaries(Collection<LaunchPathSummary.BuilderImpl> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copyFromBuilder(launchPathSummaries);
        }

        @Override
        public final Builder launchPathSummaries(Collection<LaunchPathSummary> launchPathSummaries) {
            this.launchPathSummaries = LaunchPathSummariesCopier.copy(launchPathSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPathSummaries(LaunchPathSummary ... launchPathSummaries) {
            this.launchPathSummaries(Arrays.asList(launchPathSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPathSummaries(Consumer<LaunchPathSummary.Builder> ... launchPathSummaries) {
            this.launchPathSummaries(Stream.of(launchPathSummaries).map(c -> (LaunchPathSummary)((LaunchPathSummary.Builder)LaunchPathSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public ListLaunchPathsResponse build() {
            return new ListLaunchPathsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceCatalogResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLaunchPathsResponse> {
        public Builder launchPathSummaries(Collection<LaunchPathSummary> var1);

        public Builder launchPathSummaries(LaunchPathSummary ... var1);

        public Builder launchPathSummaries(Consumer<LaunchPathSummary.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

