/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalog.ServiceCatalogAsyncClient;
import software.amazon.awssdk.services.servicecatalog.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsRequest;
import software.amazon.awssdk.services.servicecatalog.model.GetProvisionedProductOutputsResponse;

public class GetProvisionedProductOutputsPublisher
implements SdkPublisher<GetProvisionedProductOutputsResponse> {
    private final ServiceCatalogAsyncClient client;
    private final GetProvisionedProductOutputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetProvisionedProductOutputsPublisher(ServiceCatalogAsyncClient client, GetProvisionedProductOutputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetProvisionedProductOutputsPublisher(ServiceCatalogAsyncClient client, GetProvisionedProductOutputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetProvisionedProductOutputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetProvisionedProductOutputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetProvisionedProductOutputsResponseFetcher
    implements AsyncPageFetcher<GetProvisionedProductOutputsResponse> {
        private GetProvisionedProductOutputsResponseFetcher() {
        }

        public boolean hasNextPage(GetProvisionedProductOutputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public CompletableFuture<GetProvisionedProductOutputsResponse> nextPage(GetProvisionedProductOutputsResponse previousPage) {
            if (previousPage == null) {
                return GetProvisionedProductOutputsPublisher.this.client.getProvisionedProductOutputs(GetProvisionedProductOutputsPublisher.this.firstRequest);
            }
            return GetProvisionedProductOutputsPublisher.this.client.getProvisionedProductOutputs((GetProvisionedProductOutputsRequest)((Object)GetProvisionedProductOutputsPublisher.this.firstRequest.toBuilder().pageToken(previousPage.nextPageToken()).build()));
        }
    }
}

