/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalogappregistry.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.ServiceCatalogAppRegistryAsyncClient;
import software.amazon.awssdk.services.servicecatalogappregistry.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesRequest;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ListAssociatedResourcesResponse;
import software.amazon.awssdk.services.servicecatalogappregistry.model.ResourceInfo;

public class ListAssociatedResourcesPublisher
implements SdkPublisher<ListAssociatedResourcesResponse> {
    private final ServiceCatalogAppRegistryAsyncClient client;
    private final ListAssociatedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssociatedResourcesPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAssociatedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssociatedResourcesPublisher(ServiceCatalogAppRegistryAsyncClient client, ListAssociatedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssociatedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssociatedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResourceInfo> resources() {
        Function<ListAssociatedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.resources() != null) {
                return response.resources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssociatedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssociatedResourcesResponseFetcher
    implements AsyncPageFetcher<ListAssociatedResourcesResponse> {
        private ListAssociatedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAssociatedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssociatedResourcesResponse> nextPage(ListAssociatedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAssociatedResourcesPublisher.this.client.listAssociatedResources(ListAssociatedResourcesPublisher.this.firstRequest);
            }
            return ListAssociatedResourcesPublisher.this.client.listAssociatedResources((ListAssociatedResourcesRequest)((Object)ListAssociatedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

