/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.servicequotas.DefaultServiceQuotasBaseClientBuilder;
import software.amazon.awssdk.services.servicequotas.DefaultServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClientBuilder;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasServiceClientConfiguration;
import software.amazon.awssdk.services.servicequotas.endpoints.ServiceQuotasEndpointProvider;

@SdkInternalApi
final class DefaultServiceQuotasClientBuilder
extends DefaultServiceQuotasBaseClientBuilder<ServiceQuotasClientBuilder, ServiceQuotasClient>
implements ServiceQuotasClientBuilder {
    DefaultServiceQuotasClientBuilder() {
    }

    @Override
    public DefaultServiceQuotasClientBuilder endpointProvider(ServiceQuotasEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ServiceQuotasClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultServiceQuotasClientBuilder.validateClientOptions(clientConfiguration);
        ServiceQuotasServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultServiceQuotasClient client = new DefaultServiceQuotasClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ServiceQuotasServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ServiceQuotasServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

