/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RequestStatus {
    PENDING("PENDING"),
    CASE_OPENED("CASE_OPENED"),
    APPROVED("APPROVED"),
    DENIED("DENIED"),
    CASE_CLOSED("CASE_CLOSED"),
    NOT_APPROVED("NOT_APPROVED"),
    INVALID_REQUEST("INVALID_REQUEST"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RequestStatus> VALUE_MAP;
    private final String value;

    private RequestStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RequestStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RequestStatus> knownValues() {
        EnumSet<RequestStatus> knownValues = EnumSet.allOf(RequestStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RequestStatus.class, RequestStatus::toString);
    }
}

