/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sesv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sesv2.model.ContactListImportAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContactListDestination
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContactListDestination> {
    private static final SdkField<String> CONTACT_LIST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactListName").getter(ContactListDestination.getter(ContactListDestination::contactListName)).setter(ContactListDestination.setter(Builder::contactListName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListName").build()}).build();
    private static final SdkField<String> CONTACT_LIST_IMPORT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContactListImportAction").getter(ContactListDestination.getter(ContactListDestination::contactListImportActionAsString)).setter(ContactListDestination.setter(Builder::contactListImportAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactListImportAction").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACT_LIST_NAME_FIELD, CONTACT_LIST_IMPORT_ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String contactListName;
    private final String contactListImportAction;

    private ContactListDestination(BuilderImpl builder) {
        this.contactListName = builder.contactListName;
        this.contactListImportAction = builder.contactListImportAction;
    }

    public final String contactListName() {
        return this.contactListName;
    }

    public final ContactListImportAction contactListImportAction() {
        return ContactListImportAction.fromValue(this.contactListImportAction);
    }

    public final String contactListImportActionAsString() {
        return this.contactListImportAction;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contactListName());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactListImportActionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContactListDestination)) {
            return false;
        }
        ContactListDestination other = (ContactListDestination)obj;
        return Objects.equals(this.contactListName(), other.contactListName()) && Objects.equals(this.contactListImportActionAsString(), other.contactListImportActionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ContactListDestination").add("ContactListName", (Object)this.contactListName()).add("ContactListImportAction", (Object)this.contactListImportActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContactListName": {
                return Optional.ofNullable(clazz.cast(this.contactListName()));
            }
            case "ContactListImportAction": {
                return Optional.ofNullable(clazz.cast(this.contactListImportActionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContactListDestination, T> g) {
        return obj -> g.apply((ContactListDestination)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String contactListName;
        private String contactListImportAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ContactListDestination model) {
            this.contactListName(model.contactListName);
            this.contactListImportAction(model.contactListImportAction);
        }

        public final String getContactListName() {
            return this.contactListName;
        }

        public final void setContactListName(String contactListName) {
            this.contactListName = contactListName;
        }

        @Override
        public final Builder contactListName(String contactListName) {
            this.contactListName = contactListName;
            return this;
        }

        public final String getContactListImportAction() {
            return this.contactListImportAction;
        }

        public final void setContactListImportAction(String contactListImportAction) {
            this.contactListImportAction = contactListImportAction;
        }

        @Override
        public final Builder contactListImportAction(String contactListImportAction) {
            this.contactListImportAction = contactListImportAction;
            return this;
        }

        @Override
        public final Builder contactListImportAction(ContactListImportAction contactListImportAction) {
            this.contactListImportAction(contactListImportAction == null ? null : contactListImportAction.toString());
            return this;
        }

        public ContactListDestination build() {
            return new ContactListDestination(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContactListDestination> {
        public Builder contactListName(String var1);

        public Builder contactListImportAction(String var1);

        public Builder contactListImportAction(ContactListImportAction var1);
    }
}

