/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.snowdevicemanagement.DefaultSnowDeviceManagementBaseClientBuilder;
import software.amazon.awssdk.services.snowdevicemanagement.DefaultSnowDeviceManagementClient;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementClient;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementClientBuilder;
import software.amazon.awssdk.services.snowdevicemanagement.SnowDeviceManagementServiceClientConfiguration;
import software.amazon.awssdk.services.snowdevicemanagement.endpoints.SnowDeviceManagementEndpointProvider;

@SdkInternalApi
final class DefaultSnowDeviceManagementClientBuilder
extends DefaultSnowDeviceManagementBaseClientBuilder<SnowDeviceManagementClientBuilder, SnowDeviceManagementClient>
implements SnowDeviceManagementClientBuilder {
    DefaultSnowDeviceManagementClientBuilder() {
    }

    @Override
    public DefaultSnowDeviceManagementClientBuilder endpointProvider(SnowDeviceManagementEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final SnowDeviceManagementClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultSnowDeviceManagementClientBuilder.validateClientOptions(clientConfiguration);
        SnowDeviceManagementServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultSnowDeviceManagementClient client = new DefaultSnowDeviceManagementClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private SnowDeviceManagementServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return SnowDeviceManagementServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

