/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.snowdevicemanagement.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.snowdevicemanagement.model.SnowDeviceManagementResponse;
import software.amazon.awssdk.services.snowdevicemanagement.model.TagMapCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.TargetListCopier;
import software.amazon.awssdk.services.snowdevicemanagement.model.TaskState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTaskResponse
extends SnowDeviceManagementResponse
implements ToCopyableBuilder<Builder, DescribeTaskResponse> {
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(DescribeTaskResponse.getter(DescribeTaskResponse::completedAt)).setter(DescribeTaskResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DescribeTaskResponse.getter(DescribeTaskResponse::createdAt)).setter(DescribeTaskResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(DescribeTaskResponse.getter(DescribeTaskResponse::description)).setter(DescribeTaskResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(DescribeTaskResponse.getter(DescribeTaskResponse::lastUpdatedAt)).setter(DescribeTaskResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(DescribeTaskResponse.getter(DescribeTaskResponse::stateAsString)).setter(DescribeTaskResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(DescribeTaskResponse.getter(DescribeTaskResponse::tags)).setter(DescribeTaskResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targets").getter(DescribeTaskResponse.getter(DescribeTaskResponse::targets)).setter(DescribeTaskResponse.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TASK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskArn").getter(DescribeTaskResponse.getter(DescribeTaskResponse::taskArn)).setter(DescribeTaskResponse.setter(Builder::taskArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskArn").build()}).build();
    private static final SdkField<String> TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("taskId").getter(DescribeTaskResponse.getter(DescribeTaskResponse::taskId)).setter(DescribeTaskResponse.setter(Builder::taskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_AT_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_AT_FIELD, STATE_FIELD, TAGS_FIELD, TARGETS_FIELD, TASK_ARN_FIELD, TASK_ID_FIELD));
    private final Instant completedAt;
    private final Instant createdAt;
    private final String description;
    private final Instant lastUpdatedAt;
    private final String state;
    private final Map<String, String> tags;
    private final List<String> targets;
    private final String taskArn;
    private final String taskId;

    private DescribeTaskResponse(BuilderImpl builder) {
        super(builder);
        this.completedAt = builder.completedAt;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.state = builder.state;
        this.tags = builder.tags;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.taskId = builder.taskId;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final TaskState state() {
        return TaskState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final String taskArn() {
        return this.taskArn;
    }

    public final String taskId() {
        return this.taskId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTaskResponse)) {
            return false;
        }
        DescribeTaskResponse other = (DescribeTaskResponse)((Object)obj);
        return Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.stateAsString(), other.stateAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.taskArn(), other.taskArn()) && Objects.equals(this.taskId(), other.taskId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTaskResponse").add("CompletedAt", (Object)this.completedAt()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("State", (Object)this.stateAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("TaskArn", (Object)this.taskArn()).add("TaskId", (Object)this.taskId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "taskArn": {
                return Optional.ofNullable(clazz.cast(this.taskArn()));
            }
            case "taskId": {
                return Optional.ofNullable(clazz.cast(this.taskId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTaskResponse, T> g) {
        return obj -> g.apply((DescribeTaskResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SnowDeviceManagementResponse.BuilderImpl
    implements Builder {
        private Instant completedAt;
        private Instant createdAt;
        private String description;
        private Instant lastUpdatedAt;
        private String state;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private String taskArn;
        private String taskId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTaskResponse model) {
            super(model);
            this.completedAt(model.completedAt);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.state(model.state);
            this.tags(model.tags);
            this.targets(model.targets);
            this.taskArn(model.taskArn);
            this.taskId(model.taskId);
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(TaskState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = TargetListCopier.copy(targets);
        }

        @Override
        public final Builder targets(Collection<String> targets) {
            this.targets = TargetListCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final String getTaskArn() {
            return this.taskArn;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final String getTaskId() {
            return this.taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        @Override
        public DescribeTaskResponse build() {
            return new DescribeTaskResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SnowDeviceManagementResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTaskResponse> {
        public Builder completedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder state(String var1);

        public Builder state(TaskState var1);

        public Builder tags(Map<String, String> var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder taskArn(String var1);

        public Builder taskId(String var1);
    }
}

