/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SessionFilterKey {
    INVOKED_AFTER("InvokedAfter"),
    INVOKED_BEFORE("InvokedBefore"),
    TARGET("Target"),
    OWNER("Owner"),
    STATUS("Status"),
    SESSION_ID("SessionId"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SessionFilterKey> VALUE_MAP;
    private final String value;

    private SessionFilterKey(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SessionFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SessionFilterKey> knownValues() {
        EnumSet<SessionFilterKey> knownValues = EnumSet.allOf(SessionFilterKey.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SessionFilterKey.class, SessionFilterKey::toString);
    }
}

