/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmcontacts.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssmcontacts.SsmContactsAsyncClient;
import software.amazon.awssdk.services.ssmcontacts.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationsRequest;
import software.amazon.awssdk.services.ssmcontacts.model.ListRotationsResponse;
import software.amazon.awssdk.services.ssmcontacts.model.Rotation;

public class ListRotationsPublisher
implements SdkPublisher<ListRotationsResponse> {
    private final SsmContactsAsyncClient client;
    private final ListRotationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRotationsPublisher(SsmContactsAsyncClient client, ListRotationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRotationsPublisher(SsmContactsAsyncClient client, ListRotationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRotationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRotationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Rotation> rotations() {
        Function<ListRotationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.rotations() != null) {
                return response.rotations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRotationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRotationsResponseFetcher
    implements AsyncPageFetcher<ListRotationsResponse> {
        private ListRotationsResponseFetcher() {
        }

        public boolean hasNextPage(ListRotationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRotationsResponse> nextPage(ListRotationsResponse previousPage) {
            if (previousPage == null) {
                return ListRotationsPublisher.this.client.listRotations(ListRotationsPublisher.this.firstRequest);
            }
            return ListRotationsPublisher.this.client.listRotations((ListRotationsRequest)((Object)ListRotationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

