/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ApplicationType {
    HANA("HANA"),
    SAP_ABAP("SAP_ABAP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ApplicationType> VALUE_MAP;
    private final String value;

    private ApplicationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ApplicationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ApplicationType> knownValues() {
        EnumSet<ApplicationType> knownValues = EnumSet.allOf(ApplicationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ApplicationType.class, ApplicationType::toString);
    }
}

