/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClusterStatus {
    ONLINE("ONLINE"),
    STANDBY("STANDBY"),
    MAINTENANCE("MAINTENANCE"),
    OFFLINE("OFFLINE"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClusterStatus> VALUE_MAP;
    private final String value;

    private ClusterStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClusterStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClusterStatus> knownValues() {
        EnumSet<ClusterStatus> knownValues = EnumSet.allOf(ClusterStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClusterStatus.class, ClusterStatus::toString);
    }
}

