/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComponentStatus {
    ACTIVATED("ACTIVATED"),
    STARTING("STARTING"),
    STOPPED("STOPPED"),
    STOPPING("STOPPING"),
    RUNNING("RUNNING"),
    RUNNING_WITH_ERROR("RUNNING_WITH_ERROR"),
    UNDEFINED("UNDEFINED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComponentStatus> VALUE_MAP;
    private final String value;

    private ComponentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComponentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComponentStatus> knownValues() {
        EnumSet<ComponentStatus> knownValues = EnumSet.allOf(ComponentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComponentStatus.class, ComponentStatus::toString);
    }
}

