/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FilterOperator {
    EQUALS("Equals"),
    GREATER_THAN_OR_EQUALS("GreaterThanOrEquals"),
    LESS_THAN_OR_EQUALS("LessThanOrEquals"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FilterOperator> VALUE_MAP;
    private final String value;

    private FilterOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FilterOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FilterOperator> knownValues() {
        EnumSet<FilterOperator> knownValues = EnumSet.allOf(FilterOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FilterOperator.class, FilterOperator::toString);
    }
}

