/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssmsap.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OperationMode {
    PRIMARY("PRIMARY"),
    LOGREPLAY("LOGREPLAY"),
    DELTA_DATASHIPPING("DELTA_DATASHIPPING"),
    LOGREPLAY_READACCESS("LOGREPLAY_READACCESS"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OperationMode> VALUE_MAP;
    private final String value;

    private OperationMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OperationMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OperationMode> knownValues() {
        EnumSet<OperationMode> knownValues = EnumSet.allOf(OperationMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OperationMode.class, OperationMode::toString);
    }
}

