/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.storagegateway.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.storagegateway.model.DiskAttributeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Disk
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Disk> {
    private static final SdkField<String> DISK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskId").getter(Disk.getter(Disk::diskId)).setter(Disk.setter(Builder::diskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskId").build()}).build();
    private static final SdkField<String> DISK_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskPath").getter(Disk.getter(Disk::diskPath)).setter(Disk.setter(Builder::diskPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskPath").build()}).build();
    private static final SdkField<String> DISK_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskNode").getter(Disk.getter(Disk::diskNode)).setter(Disk.setter(Builder::diskNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskNode").build()}).build();
    private static final SdkField<String> DISK_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskStatus").getter(Disk.getter(Disk::diskStatus)).setter(Disk.setter(Builder::diskStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskStatus").build()}).build();
    private static final SdkField<Long> DISK_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DiskSizeInBytes").getter(Disk.getter(Disk::diskSizeInBytes)).setter(Disk.setter(Builder::diskSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskSizeInBytes").build()}).build();
    private static final SdkField<String> DISK_ALLOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskAllocationType").getter(Disk.getter(Disk::diskAllocationType)).setter(Disk.setter(Builder::diskAllocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskAllocationType").build()}).build();
    private static final SdkField<String> DISK_ALLOCATION_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiskAllocationResource").getter(Disk.getter(Disk::diskAllocationResource)).setter(Disk.setter(Builder::diskAllocationResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskAllocationResource").build()}).build();
    private static final SdkField<List<String>> DISK_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DiskAttributeList").getter(Disk.getter(Disk::diskAttributeList)).setter(Disk.setter(Builder::diskAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiskAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISK_ID_FIELD, DISK_PATH_FIELD, DISK_NODE_FIELD, DISK_STATUS_FIELD, DISK_SIZE_IN_BYTES_FIELD, DISK_ALLOCATION_TYPE_FIELD, DISK_ALLOCATION_RESOURCE_FIELD, DISK_ATTRIBUTE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String diskId;
    private final String diskPath;
    private final String diskNode;
    private final String diskStatus;
    private final Long diskSizeInBytes;
    private final String diskAllocationType;
    private final String diskAllocationResource;
    private final List<String> diskAttributeList;

    private Disk(BuilderImpl builder) {
        this.diskId = builder.diskId;
        this.diskPath = builder.diskPath;
        this.diskNode = builder.diskNode;
        this.diskStatus = builder.diskStatus;
        this.diskSizeInBytes = builder.diskSizeInBytes;
        this.diskAllocationType = builder.diskAllocationType;
        this.diskAllocationResource = builder.diskAllocationResource;
        this.diskAttributeList = builder.diskAttributeList;
    }

    public final String diskId() {
        return this.diskId;
    }

    public final String diskPath() {
        return this.diskPath;
    }

    public final String diskNode() {
        return this.diskNode;
    }

    public final String diskStatus() {
        return this.diskStatus;
    }

    public final Long diskSizeInBytes() {
        return this.diskSizeInBytes;
    }

    public final String diskAllocationType() {
        return this.diskAllocationType;
    }

    public final String diskAllocationResource() {
        return this.diskAllocationResource;
    }

    public final boolean hasDiskAttributeList() {
        return this.diskAttributeList != null && !(this.diskAttributeList instanceof SdkAutoConstructList);
    }

    public final List<String> diskAttributeList() {
        return this.diskAttributeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.diskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskAllocationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.diskAllocationResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDiskAttributeList() ? this.diskAttributeList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)obj;
        return Objects.equals(this.diskId(), other.diskId()) && Objects.equals(this.diskPath(), other.diskPath()) && Objects.equals(this.diskNode(), other.diskNode()) && Objects.equals(this.diskStatus(), other.diskStatus()) && Objects.equals(this.diskSizeInBytes(), other.diskSizeInBytes()) && Objects.equals(this.diskAllocationType(), other.diskAllocationType()) && Objects.equals(this.diskAllocationResource(), other.diskAllocationResource()) && this.hasDiskAttributeList() == other.hasDiskAttributeList() && Objects.equals(this.diskAttributeList(), other.diskAttributeList());
    }

    public final String toString() {
        return ToString.builder((String)"Disk").add("DiskId", (Object)this.diskId()).add("DiskPath", (Object)this.diskPath()).add("DiskNode", (Object)this.diskNode()).add("DiskStatus", (Object)this.diskStatus()).add("DiskSizeInBytes", (Object)this.diskSizeInBytes()).add("DiskAllocationType", (Object)this.diskAllocationType()).add("DiskAllocationResource", (Object)this.diskAllocationResource()).add("DiskAttributeList", this.hasDiskAttributeList() ? this.diskAttributeList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DiskId": {
                return Optional.ofNullable(clazz.cast(this.diskId()));
            }
            case "DiskPath": {
                return Optional.ofNullable(clazz.cast(this.diskPath()));
            }
            case "DiskNode": {
                return Optional.ofNullable(clazz.cast(this.diskNode()));
            }
            case "DiskStatus": {
                return Optional.ofNullable(clazz.cast(this.diskStatus()));
            }
            case "DiskSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.diskSizeInBytes()));
            }
            case "DiskAllocationType": {
                return Optional.ofNullable(clazz.cast(this.diskAllocationType()));
            }
            case "DiskAllocationResource": {
                return Optional.ofNullable(clazz.cast(this.diskAllocationResource()));
            }
            case "DiskAttributeList": {
                return Optional.ofNullable(clazz.cast(this.diskAttributeList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Disk, T> g) {
        return obj -> g.apply((Disk)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String diskId;
        private String diskPath;
        private String diskNode;
        private String diskStatus;
        private Long diskSizeInBytes;
        private String diskAllocationType;
        private String diskAllocationResource;
        private List<String> diskAttributeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Disk model) {
            this.diskId(model.diskId);
            this.diskPath(model.diskPath);
            this.diskNode(model.diskNode);
            this.diskStatus(model.diskStatus);
            this.diskSizeInBytes(model.diskSizeInBytes);
            this.diskAllocationType(model.diskAllocationType);
            this.diskAllocationResource(model.diskAllocationResource);
            this.diskAttributeList(model.diskAttributeList);
        }

        public final String getDiskId() {
            return this.diskId;
        }

        public final void setDiskId(String diskId) {
            this.diskId = diskId;
        }

        @Override
        public final Builder diskId(String diskId) {
            this.diskId = diskId;
            return this;
        }

        public final String getDiskPath() {
            return this.diskPath;
        }

        public final void setDiskPath(String diskPath) {
            this.diskPath = diskPath;
        }

        @Override
        public final Builder diskPath(String diskPath) {
            this.diskPath = diskPath;
            return this;
        }

        public final String getDiskNode() {
            return this.diskNode;
        }

        public final void setDiskNode(String diskNode) {
            this.diskNode = diskNode;
        }

        @Override
        public final Builder diskNode(String diskNode) {
            this.diskNode = diskNode;
            return this;
        }

        public final String getDiskStatus() {
            return this.diskStatus;
        }

        public final void setDiskStatus(String diskStatus) {
            this.diskStatus = diskStatus;
        }

        @Override
        public final Builder diskStatus(String diskStatus) {
            this.diskStatus = diskStatus;
            return this;
        }

        public final Long getDiskSizeInBytes() {
            return this.diskSizeInBytes;
        }

        public final void setDiskSizeInBytes(Long diskSizeInBytes) {
            this.diskSizeInBytes = diskSizeInBytes;
        }

        @Override
        public final Builder diskSizeInBytes(Long diskSizeInBytes) {
            this.diskSizeInBytes = diskSizeInBytes;
            return this;
        }

        public final String getDiskAllocationType() {
            return this.diskAllocationType;
        }

        public final void setDiskAllocationType(String diskAllocationType) {
            this.diskAllocationType = diskAllocationType;
        }

        @Override
        public final Builder diskAllocationType(String diskAllocationType) {
            this.diskAllocationType = diskAllocationType;
            return this;
        }

        public final String getDiskAllocationResource() {
            return this.diskAllocationResource;
        }

        public final void setDiskAllocationResource(String diskAllocationResource) {
            this.diskAllocationResource = diskAllocationResource;
        }

        @Override
        public final Builder diskAllocationResource(String diskAllocationResource) {
            this.diskAllocationResource = diskAllocationResource;
            return this;
        }

        public final Collection<String> getDiskAttributeList() {
            if (this.diskAttributeList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.diskAttributeList;
        }

        public final void setDiskAttributeList(Collection<String> diskAttributeList) {
            this.diskAttributeList = DiskAttributeListCopier.copy(diskAttributeList);
        }

        @Override
        public final Builder diskAttributeList(Collection<String> diskAttributeList) {
            this.diskAttributeList = DiskAttributeListCopier.copy(diskAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder diskAttributeList(String ... diskAttributeList) {
            this.diskAttributeList(Arrays.asList(diskAttributeList));
            return this;
        }

        public Disk build() {
            return new Disk(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Disk> {
        public Builder diskId(String var1);

        public Builder diskPath(String var1);

        public Builder diskNode(String var1);

        public Builder diskStatus(String var1);

        public Builder diskSizeInBytes(Long var1);

        public Builder diskAllocationType(String var1);

        public Builder diskAllocationResource(String var1);

        public Builder diskAttributeList(Collection<String> var1);

        public Builder diskAttributeList(String ... var1);
    }
}

