/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.tnb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.tnb.model.GetSolInstantiatedVnfInfo;
import software.amazon.awssdk.services.tnb.model.ListSolFunctionInstanceMetadata;
import software.amazon.awssdk.services.tnb.model.VnfInstantiationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSolFunctionInstanceInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListSolFunctionInstanceInfo> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::arn)).setter(ListSolFunctionInstanceInfo.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::id)).setter(ListSolFunctionInstanceInfo.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<GetSolInstantiatedVnfInfo> INSTANTIATED_VNF_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instantiatedVnfInfo").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::instantiatedVnfInfo)).setter(ListSolFunctionInstanceInfo.setter(Builder::instantiatedVnfInfo)).constructor(GetSolInstantiatedVnfInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiatedVnfInfo").build()}).build();
    private static final SdkField<String> INSTANTIATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instantiationState").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::instantiationStateAsString)).setter(ListSolFunctionInstanceInfo.setter(Builder::instantiationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instantiationState").build()}).build();
    private static final SdkField<ListSolFunctionInstanceMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::metadata)).setter(ListSolFunctionInstanceInfo.setter(Builder::metadata)).constructor(ListSolFunctionInstanceMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> NS_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nsInstanceId").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::nsInstanceId)).setter(ListSolFunctionInstanceInfo.setter(Builder::nsInstanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nsInstanceId").build()}).build();
    private static final SdkField<String> VNF_PKG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfPkgId").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::vnfPkgId)).setter(ListSolFunctionInstanceInfo.setter(Builder::vnfPkgId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgId").build()}).build();
    private static final SdkField<String> VNF_PKG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnfPkgName").getter(ListSolFunctionInstanceInfo.getter(ListSolFunctionInstanceInfo::vnfPkgName)).setter(ListSolFunctionInstanceInfo.setter(Builder::vnfPkgName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnfPkgName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, INSTANTIATED_VNF_INFO_FIELD, INSTANTIATION_STATE_FIELD, METADATA_FIELD, NS_INSTANCE_ID_FIELD, VNF_PKG_ID_FIELD, VNF_PKG_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String id;
    private final GetSolInstantiatedVnfInfo instantiatedVnfInfo;
    private final String instantiationState;
    private final ListSolFunctionInstanceMetadata metadata;
    private final String nsInstanceId;
    private final String vnfPkgId;
    private final String vnfPkgName;

    private ListSolFunctionInstanceInfo(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.instantiatedVnfInfo = builder.instantiatedVnfInfo;
        this.instantiationState = builder.instantiationState;
        this.metadata = builder.metadata;
        this.nsInstanceId = builder.nsInstanceId;
        this.vnfPkgId = builder.vnfPkgId;
        this.vnfPkgName = builder.vnfPkgName;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final GetSolInstantiatedVnfInfo instantiatedVnfInfo() {
        return this.instantiatedVnfInfo;
    }

    public final VnfInstantiationState instantiationState() {
        return VnfInstantiationState.fromValue(this.instantiationState);
    }

    public final String instantiationStateAsString() {
        return this.instantiationState;
    }

    public final ListSolFunctionInstanceMetadata metadata() {
        return this.metadata;
    }

    public final String nsInstanceId() {
        return this.nsInstanceId;
    }

    public final String vnfPkgId() {
        return this.vnfPkgId;
    }

    public final String vnfPkgName() {
        return this.vnfPkgName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.instantiatedVnfInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.instantiationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.nsInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfPkgId());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnfPkgName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolFunctionInstanceInfo)) {
            return false;
        }
        ListSolFunctionInstanceInfo other = (ListSolFunctionInstanceInfo)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.instantiatedVnfInfo(), other.instantiatedVnfInfo()) && Objects.equals(this.instantiationStateAsString(), other.instantiationStateAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.nsInstanceId(), other.nsInstanceId()) && Objects.equals(this.vnfPkgId(), other.vnfPkgId()) && Objects.equals(this.vnfPkgName(), other.vnfPkgName());
    }

    public final String toString() {
        return ToString.builder((String)"ListSolFunctionInstanceInfo").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("InstantiatedVnfInfo", (Object)this.instantiatedVnfInfo()).add("InstantiationState", (Object)this.instantiationStateAsString()).add("Metadata", (Object)this.metadata()).add("NsInstanceId", (Object)this.nsInstanceId()).add("VnfPkgId", (Object)this.vnfPkgId()).add("VnfPkgName", (Object)this.vnfPkgName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "instantiatedVnfInfo": {
                return Optional.ofNullable(clazz.cast(this.instantiatedVnfInfo()));
            }
            case "instantiationState": {
                return Optional.ofNullable(clazz.cast(this.instantiationStateAsString()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "nsInstanceId": {
                return Optional.ofNullable(clazz.cast(this.nsInstanceId()));
            }
            case "vnfPkgId": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgId()));
            }
            case "vnfPkgName": {
                return Optional.ofNullable(clazz.cast(this.vnfPkgName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSolFunctionInstanceInfo, T> g) {
        return obj -> g.apply((ListSolFunctionInstanceInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private GetSolInstantiatedVnfInfo instantiatedVnfInfo;
        private String instantiationState;
        private ListSolFunctionInstanceMetadata metadata;
        private String nsInstanceId;
        private String vnfPkgId;
        private String vnfPkgName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolFunctionInstanceInfo model) {
            this.arn(model.arn);
            this.id(model.id);
            this.instantiatedVnfInfo(model.instantiatedVnfInfo);
            this.instantiationState(model.instantiationState);
            this.metadata(model.metadata);
            this.nsInstanceId(model.nsInstanceId);
            this.vnfPkgId(model.vnfPkgId);
            this.vnfPkgName(model.vnfPkgName);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final GetSolInstantiatedVnfInfo.Builder getInstantiatedVnfInfo() {
            return this.instantiatedVnfInfo != null ? this.instantiatedVnfInfo.toBuilder() : null;
        }

        public final void setInstantiatedVnfInfo(GetSolInstantiatedVnfInfo.BuilderImpl instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo != null ? instantiatedVnfInfo.build() : null;
        }

        @Override
        public final Builder instantiatedVnfInfo(GetSolInstantiatedVnfInfo instantiatedVnfInfo) {
            this.instantiatedVnfInfo = instantiatedVnfInfo;
            return this;
        }

        public final String getInstantiationState() {
            return this.instantiationState;
        }

        public final void setInstantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
        }

        @Override
        public final Builder instantiationState(String instantiationState) {
            this.instantiationState = instantiationState;
            return this;
        }

        @Override
        public final Builder instantiationState(VnfInstantiationState instantiationState) {
            this.instantiationState(instantiationState == null ? null : instantiationState.toString());
            return this;
        }

        public final ListSolFunctionInstanceMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(ListSolFunctionInstanceMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(ListSolFunctionInstanceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getNsInstanceId() {
            return this.nsInstanceId;
        }

        public final void setNsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
        }

        @Override
        public final Builder nsInstanceId(String nsInstanceId) {
            this.nsInstanceId = nsInstanceId;
            return this;
        }

        public final String getVnfPkgId() {
            return this.vnfPkgId;
        }

        public final void setVnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
        }

        @Override
        public final Builder vnfPkgId(String vnfPkgId) {
            this.vnfPkgId = vnfPkgId;
            return this;
        }

        public final String getVnfPkgName() {
            return this.vnfPkgName;
        }

        public final void setVnfPkgName(String vnfPkgName) {
            this.vnfPkgName = vnfPkgName;
        }

        @Override
        public final Builder vnfPkgName(String vnfPkgName) {
            this.vnfPkgName = vnfPkgName;
            return this;
        }

        public ListSolFunctionInstanceInfo build() {
            return new ListSolFunctionInstanceInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListSolFunctionInstanceInfo> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder instantiatedVnfInfo(GetSolInstantiatedVnfInfo var1);

        default public Builder instantiatedVnfInfo(Consumer<GetSolInstantiatedVnfInfo.Builder> instantiatedVnfInfo) {
            return this.instantiatedVnfInfo((GetSolInstantiatedVnfInfo)((GetSolInstantiatedVnfInfo.Builder)GetSolInstantiatedVnfInfo.builder().applyMutation(instantiatedVnfInfo)).build());
        }

        public Builder instantiationState(String var1);

        public Builder instantiationState(VnfInstantiationState var1);

        public Builder metadata(ListSolFunctionInstanceMetadata var1);

        default public Builder metadata(Consumer<ListSolFunctionInstanceMetadata.Builder> metadata) {
            return this.metadata((ListSolFunctionInstanceMetadata)((ListSolFunctionInstanceMetadata.Builder)ListSolFunctionInstanceMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder nsInstanceId(String var1);

        public Builder vnfPkgId(String var1);

        public Builder vnfPkgName(String var1);
    }
}

