/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribe.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.transcribe.TranscribeAsyncClient;
import software.amazon.awssdk.services.transcribe.internal.UserAgentUtils;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersRequest;
import software.amazon.awssdk.services.transcribe.model.ListVocabularyFiltersResponse;

public class ListVocabularyFiltersPublisher
implements SdkPublisher<ListVocabularyFiltersResponse> {
    private final TranscribeAsyncClient client;
    private final ListVocabularyFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVocabularyFiltersPublisher(TranscribeAsyncClient client, ListVocabularyFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVocabularyFiltersPublisher(TranscribeAsyncClient client, ListVocabularyFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVocabularyFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVocabularyFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVocabularyFiltersResponseFetcher
    implements AsyncPageFetcher<ListVocabularyFiltersResponse> {
        private ListVocabularyFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListVocabularyFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVocabularyFiltersResponse> nextPage(ListVocabularyFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListVocabularyFiltersPublisher.this.client.listVocabularyFilters(ListVocabularyFiltersPublisher.this.firstRequest);
            }
            return ListVocabularyFiltersPublisher.this.client.listVocabularyFilters((ListVocabularyFiltersRequest)((Object)ListVocabularyFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

