/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LanguageCode {
    EN_US("en-US"),
    EN_GB("en-GB"),
    ES_US("es-US"),
    FR_CA("fr-CA"),
    FR_FR("fr-FR"),
    EN_AU("en-AU"),
    IT_IT("it-IT"),
    DE_DE("de-DE"),
    PT_BR("pt-BR"),
    JA_JP("ja-JP"),
    KO_KR("ko-KR"),
    ZH_CN("zh-CN"),
    HI_IN("hi-IN"),
    TH_TH("th-TH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LanguageCode> VALUE_MAP;
    private final String value;

    private LanguageCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LanguageCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LanguageCode> knownValues() {
        EnumSet<LanguageCode> knownValues = EnumSet.allOf(LanguageCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LanguageCode.class, LanguageCode::toString);
    }
}

