/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transcribestreaming.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternative;
import software.amazon.awssdk.services.transcribestreaming.model.MedicalAlternativeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MedicalResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MedicalResult> {
    private static final SdkField<String> RESULT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultId").getter(MedicalResult.getter(MedicalResult::resultId)).setter(MedicalResult.setter(Builder::resultId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultId").build()}).build();
    private static final SdkField<Double> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("StartTime").getter(MedicalResult.getter(MedicalResult::startTime)).setter(MedicalResult.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Double> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("EndTime").getter(MedicalResult.getter(MedicalResult::endTime)).setter(MedicalResult.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Boolean> IS_PARTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsPartial").getter(MedicalResult.getter(MedicalResult::isPartial)).setter(MedicalResult.setter(Builder::isPartial)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartial").build()}).build();
    private static final SdkField<List<MedicalAlternative>> ALTERNATIVES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Alternatives").getter(MedicalResult.getter(MedicalResult::alternatives)).setter(MedicalResult.setter(Builder::alternatives)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Alternatives").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MedicalAlternative::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelId").getter(MedicalResult.getter(MedicalResult::channelId)).setter(MedicalResult.setter(Builder::channelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, IS_PARTIAL_FIELD, ALTERNATIVES_FIELD, CHANNEL_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String resultId;
    private final Double startTime;
    private final Double endTime;
    private final Boolean isPartial;
    private final List<MedicalAlternative> alternatives;
    private final String channelId;

    private MedicalResult(BuilderImpl builder) {
        this.resultId = builder.resultId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.isPartial = builder.isPartial;
        this.alternatives = builder.alternatives;
        this.channelId = builder.channelId;
    }

    public final String resultId() {
        return this.resultId;
    }

    public final Double startTime() {
        return this.startTime;
    }

    public final Double endTime() {
        return this.endTime;
    }

    public final Boolean isPartial() {
        return this.isPartial;
    }

    public final boolean hasAlternatives() {
        return this.alternatives != null && !(this.alternatives instanceof SdkAutoConstructList);
    }

    public final List<MedicalAlternative> alternatives() {
        return this.alternatives;
    }

    public final String channelId() {
        return this.channelId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.resultId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPartial());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlternatives() ? this.alternatives() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MedicalResult)) {
            return false;
        }
        MedicalResult other = (MedicalResult)obj;
        return Objects.equals(this.resultId(), other.resultId()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.isPartial(), other.isPartial()) && this.hasAlternatives() == other.hasAlternatives() && Objects.equals(this.alternatives(), other.alternatives()) && Objects.equals(this.channelId(), other.channelId());
    }

    public final String toString() {
        return ToString.builder((String)"MedicalResult").add("ResultId", (Object)this.resultId()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("IsPartial", (Object)this.isPartial()).add("Alternatives", this.hasAlternatives() ? this.alternatives() : null).add("ChannelId", (Object)this.channelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultId": {
                return Optional.ofNullable(clazz.cast(this.resultId()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "IsPartial": {
                return Optional.ofNullable(clazz.cast(this.isPartial()));
            }
            case "Alternatives": {
                return Optional.ofNullable(clazz.cast(this.alternatives()));
            }
            case "ChannelId": {
                return Optional.ofNullable(clazz.cast(this.channelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MedicalResult, T> g) {
        return obj -> g.apply((MedicalResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String resultId;
        private Double startTime;
        private Double endTime;
        private Boolean isPartial;
        private List<MedicalAlternative> alternatives = DefaultSdkAutoConstructList.getInstance();
        private String channelId;

        private BuilderImpl() {
        }

        private BuilderImpl(MedicalResult model) {
            this.resultId(model.resultId);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.isPartial(model.isPartial);
            this.alternatives(model.alternatives);
            this.channelId(model.channelId);
        }

        public final String getResultId() {
            return this.resultId;
        }

        public final void setResultId(String resultId) {
            this.resultId = resultId;
        }

        @Override
        public final Builder resultId(String resultId) {
            this.resultId = resultId;
            return this;
        }

        public final Double getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Double startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Double startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Double getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Double endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Double endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Boolean getIsPartial() {
            return this.isPartial;
        }

        public final void setIsPartial(Boolean isPartial) {
            this.isPartial = isPartial;
        }

        @Override
        public final Builder isPartial(Boolean isPartial) {
            this.isPartial = isPartial;
            return this;
        }

        public final List<MedicalAlternative.Builder> getAlternatives() {
            List<MedicalAlternative.Builder> result = MedicalAlternativeListCopier.copyToBuilder(this.alternatives);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlternatives(Collection<MedicalAlternative.BuilderImpl> alternatives) {
            this.alternatives = MedicalAlternativeListCopier.copyFromBuilder(alternatives);
        }

        @Override
        public final Builder alternatives(Collection<MedicalAlternative> alternatives) {
            this.alternatives = MedicalAlternativeListCopier.copy(alternatives);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(MedicalAlternative ... alternatives) {
            this.alternatives(Arrays.asList(alternatives));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alternatives(Consumer<MedicalAlternative.Builder> ... alternatives) {
            this.alternatives(Stream.of(alternatives).map(c -> (MedicalAlternative)((MedicalAlternative.Builder)MedicalAlternative.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelId() {
            return this.channelId;
        }

        public final void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public final Builder channelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        public MedicalResult build() {
            return new MedicalResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MedicalResult> {
        public Builder resultId(String var1);

        public Builder startTime(Double var1);

        public Builder endTime(Double var1);

        public Builder isPartial(Boolean var1);

        public Builder alternatives(Collection<MedicalAlternative> var1);

        public Builder alternatives(MedicalAlternative ... var1);

        public Builder alternatives(Consumer<MedicalAlternative.Builder> ... var1);

        public Builder channelId(String var1);
    }
}

