/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.translate.TranslateAsyncClient;
import software.amazon.awssdk.services.translate.internal.UserAgentUtils;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsRequest;
import software.amazon.awssdk.services.translate.model.ListTextTranslationJobsResponse;

public class ListTextTranslationJobsPublisher
implements SdkPublisher<ListTextTranslationJobsResponse> {
    private final TranslateAsyncClient client;
    private final ListTextTranslationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTextTranslationJobsPublisher(TranslateAsyncClient client, ListTextTranslationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTextTranslationJobsPublisher(TranslateAsyncClient client, ListTextTranslationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTextTranslationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTextTranslationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListTextTranslationJobsResponseFetcher
    implements AsyncPageFetcher<ListTextTranslationJobsResponse> {
        private ListTextTranslationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTextTranslationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTextTranslationJobsResponse> nextPage(ListTextTranslationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTextTranslationJobsPublisher.this.client.listTextTranslationJobs(ListTextTranslationJobsPublisher.this.firstRequest);
            }
            return ListTextTranslationJobsPublisher.this.client.listTextTranslationJobs((ListTextTranslationJobsRequest)((Object)ListTextTranslationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

