/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ByteMatchTuple;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteMatchSetUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteMatchSetUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ByteMatchSetUpdate.getter(ByteMatchSetUpdate::actionAsString)).setter(ByteMatchSetUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<ByteMatchTuple> BYTE_MATCH_TUPLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ByteMatchTuple").getter(ByteMatchSetUpdate.getter(ByteMatchSetUpdate::byteMatchTuple)).setter(ByteMatchSetUpdate.setter(Builder::byteMatchTuple)).constructor(ByteMatchTuple::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ByteMatchTuple").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, BYTE_MATCH_TUPLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final ByteMatchTuple byteMatchTuple;

    private ByteMatchSetUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.byteMatchTuple = builder.byteMatchTuple;
    }

    public final ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final ByteMatchTuple byteMatchTuple() {
        return this.byteMatchTuple;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byteMatchTuple());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteMatchSetUpdate)) {
            return false;
        }
        ByteMatchSetUpdate other = (ByteMatchSetUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.byteMatchTuple(), other.byteMatchTuple());
    }

    public final String toString() {
        return ToString.builder((String)"ByteMatchSetUpdate").add("Action", (Object)this.actionAsString()).add("ByteMatchTuple", (Object)this.byteMatchTuple()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ByteMatchTuple": {
                return Optional.ofNullable(clazz.cast(this.byteMatchTuple()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ByteMatchSetUpdate, T> g) {
        return obj -> g.apply((ByteMatchSetUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ByteMatchTuple byteMatchTuple;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteMatchSetUpdate model) {
            this.action(model.action);
            this.byteMatchTuple(model.byteMatchTuple);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final ByteMatchTuple.Builder getByteMatchTuple() {
            return this.byteMatchTuple != null ? this.byteMatchTuple.toBuilder() : null;
        }

        public final void setByteMatchTuple(ByteMatchTuple.BuilderImpl byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple != null ? byteMatchTuple.build() : null;
        }

        @Override
        public final Builder byteMatchTuple(ByteMatchTuple byteMatchTuple) {
            this.byteMatchTuple = byteMatchTuple;
            return this;
        }

        public ByteMatchSetUpdate build() {
            return new ByteMatchSetUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteMatchSetUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder byteMatchTuple(ByteMatchTuple var1);

        default public Builder byteMatchTuple(Consumer<ByteMatchTuple.Builder> byteMatchTuple) {
            return this.byteMatchTuple((ByteMatchTuple)((ByteMatchTuple.Builder)ByteMatchTuple.builder().applyMutation(byteMatchTuple)).build());
        }
    }
}

