/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WafActionType {
    BLOCK("BLOCK"),
    ALLOW("ALLOW"),
    COUNT("COUNT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WafActionType> VALUE_MAP;
    private final String value;

    private WafActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WafActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WafActionType> knownValues() {
        EnumSet<WafActionType> knownValues = EnumSet.allOf(WafActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WafActionType.class, WafActionType::toString);
    }
}

