/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CheckProvider {
    TRUSTED_ADVISOR("TRUSTED_ADVISOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CheckProvider> VALUE_MAP;
    private final String value;

    private CheckProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CheckProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CheckProvider> knownValues() {
        EnumSet<CheckProvider> knownValues = EnumSet.allOf(CheckProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CheckProvider.class, CheckProvider::toString);
    }
}

