/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.wellarchitected.model.LensStatus;
import software.amazon.awssdk.services.wellarchitected.model.Risk;
import software.amazon.awssdk.services.wellarchitected.model.RiskCountsCopier;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadProfile;
import software.amazon.awssdk.services.wellarchitected.model.WorkloadProfilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LensReviewSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LensReviewSummary> {
    private static final SdkField<String> LENS_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensAlias").getter(LensReviewSummary.getter(LensReviewSummary::lensAlias)).setter(LensReviewSummary.setter(Builder::lensAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensAlias").build()}).build();
    private static final SdkField<String> LENS_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensArn").getter(LensReviewSummary.getter(LensReviewSummary::lensArn)).setter(LensReviewSummary.setter(Builder::lensArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensArn").build()}).build();
    private static final SdkField<String> LENS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensVersion").getter(LensReviewSummary.getter(LensReviewSummary::lensVersion)).setter(LensReviewSummary.setter(Builder::lensVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensVersion").build()}).build();
    private static final SdkField<String> LENS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensName").getter(LensReviewSummary.getter(LensReviewSummary::lensName)).setter(LensReviewSummary.setter(Builder::lensName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensName").build()}).build();
    private static final SdkField<String> LENS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LensStatus").getter(LensReviewSummary.getter(LensReviewSummary::lensStatusAsString)).setter(LensReviewSummary.setter(Builder::lensStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LensStatus").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(LensReviewSummary.getter(LensReviewSummary::updatedAt)).setter(LensReviewSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final SdkField<Map<String, Integer>> RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("RiskCounts").getter(LensReviewSummary.getter(LensReviewSummary::riskCountsAsStrings)).setter(LensReviewSummary.setter(Builder::riskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<WorkloadProfile>> PROFILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Profiles").getter(LensReviewSummary.getter(LensReviewSummary::profiles)).setter(LensReviewSummary.setter(Builder::profiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkloadProfile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, Integer>> PRIORITIZED_RISK_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("PrioritizedRiskCounts").getter(LensReviewSummary.getter(LensReviewSummary::prioritizedRiskCountsAsStrings)).setter(LensReviewSummary.setter(Builder::prioritizedRiskCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrioritizedRiskCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LENS_ALIAS_FIELD, LENS_ARN_FIELD, LENS_VERSION_FIELD, LENS_NAME_FIELD, LENS_STATUS_FIELD, UPDATED_AT_FIELD, RISK_COUNTS_FIELD, PROFILES_FIELD, PRIORITIZED_RISK_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lensAlias;
    private final String lensArn;
    private final String lensVersion;
    private final String lensName;
    private final String lensStatus;
    private final Instant updatedAt;
    private final Map<String, Integer> riskCounts;
    private final List<WorkloadProfile> profiles;
    private final Map<String, Integer> prioritizedRiskCounts;

    private LensReviewSummary(BuilderImpl builder) {
        this.lensAlias = builder.lensAlias;
        this.lensArn = builder.lensArn;
        this.lensVersion = builder.lensVersion;
        this.lensName = builder.lensName;
        this.lensStatus = builder.lensStatus;
        this.updatedAt = builder.updatedAt;
        this.riskCounts = builder.riskCounts;
        this.profiles = builder.profiles;
        this.prioritizedRiskCounts = builder.prioritizedRiskCounts;
    }

    public final String lensAlias() {
        return this.lensAlias;
    }

    public final String lensArn() {
        return this.lensArn;
    }

    public final String lensVersion() {
        return this.lensVersion;
    }

    public final String lensName() {
        return this.lensName;
    }

    public final LensStatus lensStatus() {
        return LensStatus.fromValue(this.lensStatus);
    }

    public final String lensStatusAsString() {
        return this.lensStatus;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Map<Risk, Integer> riskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.riskCounts);
    }

    public final boolean hasRiskCounts() {
        return this.riskCounts != null && !(this.riskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> riskCountsAsStrings() {
        return this.riskCounts;
    }

    public final boolean hasProfiles() {
        return this.profiles != null && !(this.profiles instanceof SdkAutoConstructList);
    }

    public final List<WorkloadProfile> profiles() {
        return this.profiles;
    }

    public final Map<Risk, Integer> prioritizedRiskCounts() {
        return RiskCountsCopier.copyStringToEnum(this.prioritizedRiskCounts);
    }

    public final boolean hasPrioritizedRiskCounts() {
        return this.prioritizedRiskCounts != null && !(this.prioritizedRiskCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> prioritizedRiskCountsAsStrings() {
        return this.prioritizedRiskCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lensAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lensStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRiskCounts() ? this.riskCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfiles() ? this.profiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPrioritizedRiskCounts() ? this.prioritizedRiskCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LensReviewSummary)) {
            return false;
        }
        LensReviewSummary other = (LensReviewSummary)obj;
        return Objects.equals(this.lensAlias(), other.lensAlias()) && Objects.equals(this.lensArn(), other.lensArn()) && Objects.equals(this.lensVersion(), other.lensVersion()) && Objects.equals(this.lensName(), other.lensName()) && Objects.equals(this.lensStatusAsString(), other.lensStatusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasRiskCounts() == other.hasRiskCounts() && Objects.equals(this.riskCountsAsStrings(), other.riskCountsAsStrings()) && this.hasProfiles() == other.hasProfiles() && Objects.equals(this.profiles(), other.profiles()) && this.hasPrioritizedRiskCounts() == other.hasPrioritizedRiskCounts() && Objects.equals(this.prioritizedRiskCountsAsStrings(), other.prioritizedRiskCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"LensReviewSummary").add("LensAlias", (Object)this.lensAlias()).add("LensArn", (Object)this.lensArn()).add("LensVersion", (Object)this.lensVersion()).add("LensName", (Object)this.lensName()).add("LensStatus", (Object)this.lensStatusAsString()).add("UpdatedAt", (Object)this.updatedAt()).add("RiskCounts", this.hasRiskCounts() ? this.riskCountsAsStrings() : null).add("Profiles", this.hasProfiles() ? this.profiles() : null).add("PrioritizedRiskCounts", this.hasPrioritizedRiskCounts() ? this.prioritizedRiskCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LensAlias": {
                return Optional.ofNullable(clazz.cast(this.lensAlias()));
            }
            case "LensArn": {
                return Optional.ofNullable(clazz.cast(this.lensArn()));
            }
            case "LensVersion": {
                return Optional.ofNullable(clazz.cast(this.lensVersion()));
            }
            case "LensName": {
                return Optional.ofNullable(clazz.cast(this.lensName()));
            }
            case "LensStatus": {
                return Optional.ofNullable(clazz.cast(this.lensStatusAsString()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "RiskCounts": {
                return Optional.ofNullable(clazz.cast(this.riskCountsAsStrings()));
            }
            case "Profiles": {
                return Optional.ofNullable(clazz.cast(this.profiles()));
            }
            case "PrioritizedRiskCounts": {
                return Optional.ofNullable(clazz.cast(this.prioritizedRiskCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LensReviewSummary, T> g) {
        return obj -> g.apply((LensReviewSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lensAlias;
        private String lensArn;
        private String lensVersion;
        private String lensName;
        private String lensStatus;
        private Instant updatedAt;
        private Map<String, Integer> riskCounts = DefaultSdkAutoConstructMap.getInstance();
        private List<WorkloadProfile> profiles = DefaultSdkAutoConstructList.getInstance();
        private Map<String, Integer> prioritizedRiskCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LensReviewSummary model) {
            this.lensAlias(model.lensAlias);
            this.lensArn(model.lensArn);
            this.lensVersion(model.lensVersion);
            this.lensName(model.lensName);
            this.lensStatus(model.lensStatus);
            this.updatedAt(model.updatedAt);
            this.riskCountsWithStrings(model.riskCounts);
            this.profiles(model.profiles);
            this.prioritizedRiskCountsWithStrings(model.prioritizedRiskCounts);
        }

        public final String getLensAlias() {
            return this.lensAlias;
        }

        public final void setLensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
        }

        @Override
        public final Builder lensAlias(String lensAlias) {
            this.lensAlias = lensAlias;
            return this;
        }

        public final String getLensArn() {
            return this.lensArn;
        }

        public final void setLensArn(String lensArn) {
            this.lensArn = lensArn;
        }

        @Override
        public final Builder lensArn(String lensArn) {
            this.lensArn = lensArn;
            return this;
        }

        public final String getLensVersion() {
            return this.lensVersion;
        }

        public final void setLensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
        }

        @Override
        public final Builder lensVersion(String lensVersion) {
            this.lensVersion = lensVersion;
            return this;
        }

        public final String getLensName() {
            return this.lensName;
        }

        public final void setLensName(String lensName) {
            this.lensName = lensName;
        }

        @Override
        public final Builder lensName(String lensName) {
            this.lensName = lensName;
            return this;
        }

        public final String getLensStatus() {
            return this.lensStatus;
        }

        public final void setLensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
        }

        @Override
        public final Builder lensStatus(String lensStatus) {
            this.lensStatus = lensStatus;
            return this;
        }

        @Override
        public final Builder lensStatus(LensStatus lensStatus) {
            this.lensStatus(lensStatus == null ? null : lensStatus.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Map<String, Integer> getRiskCounts() {
            if (this.riskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.riskCounts;
        }

        public final void setRiskCounts(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
        }

        @Override
        public final Builder riskCountsWithStrings(Map<String, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copy(riskCounts);
            return this;
        }

        @Override
        public final Builder riskCounts(Map<Risk, Integer> riskCounts) {
            this.riskCounts = RiskCountsCopier.copyEnumToString(riskCounts);
            return this;
        }

        public final List<WorkloadProfile.Builder> getProfiles() {
            List<WorkloadProfile.Builder> result = WorkloadProfilesCopier.copyToBuilder(this.profiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProfiles(Collection<WorkloadProfile.BuilderImpl> profiles) {
            this.profiles = WorkloadProfilesCopier.copyFromBuilder(profiles);
        }

        @Override
        public final Builder profiles(Collection<WorkloadProfile> profiles) {
            this.profiles = WorkloadProfilesCopier.copy(profiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(WorkloadProfile ... profiles) {
            this.profiles(Arrays.asList(profiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profiles(Consumer<WorkloadProfile.Builder> ... profiles) {
            this.profiles(Stream.of(profiles).map(c -> (WorkloadProfile)((WorkloadProfile.Builder)WorkloadProfile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, Integer> getPrioritizedRiskCounts() {
            if (this.prioritizedRiskCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.prioritizedRiskCounts;
        }

        public final void setPrioritizedRiskCounts(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
        }

        @Override
        public final Builder prioritizedRiskCountsWithStrings(Map<String, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copy(prioritizedRiskCounts);
            return this;
        }

        @Override
        public final Builder prioritizedRiskCounts(Map<Risk, Integer> prioritizedRiskCounts) {
            this.prioritizedRiskCounts = RiskCountsCopier.copyEnumToString(prioritizedRiskCounts);
            return this;
        }

        public LensReviewSummary build() {
            return new LensReviewSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LensReviewSummary> {
        public Builder lensAlias(String var1);

        public Builder lensArn(String var1);

        public Builder lensVersion(String var1);

        public Builder lensName(String var1);

        public Builder lensStatus(String var1);

        public Builder lensStatus(LensStatus var1);

        public Builder updatedAt(Instant var1);

        public Builder riskCountsWithStrings(Map<String, Integer> var1);

        public Builder riskCounts(Map<Risk, Integer> var1);

        public Builder profiles(Collection<WorkloadProfile> var1);

        public Builder profiles(WorkloadProfile ... var1);

        public Builder profiles(Consumer<WorkloadProfile.Builder> ... var1);

        public Builder prioritizedRiskCountsWithStrings(Map<String, Integer> var1);

        public Builder prioritizedRiskCounts(Map<Risk, Integer> var1);
    }
}

