/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.wellarchitected.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.wellarchitected.model.ProfileTemplateQuestion;
import software.amazon.awssdk.services.wellarchitected.model.TemplateQuestionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfileTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfileTemplate> {
    private static final SdkField<String> TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateName").getter(ProfileTemplate.getter(ProfileTemplate::templateName)).setter(ProfileTemplate.setter(Builder::templateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateName").build()}).build();
    private static final SdkField<List<ProfileTemplateQuestion>> TEMPLATE_QUESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TemplateQuestions").getter(ProfileTemplate.getter(ProfileTemplate::templateQuestions)).setter(ProfileTemplate.setter(Builder::templateQuestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateQuestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileTemplateQuestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(ProfileTemplate.getter(ProfileTemplate::createdAt)).setter(ProfileTemplate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(ProfileTemplate.getter(ProfileTemplate::updatedAt)).setter(ProfileTemplate.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_NAME_FIELD, TEMPLATE_QUESTIONS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String templateName;
    private final List<ProfileTemplateQuestion> templateQuestions;
    private final Instant createdAt;
    private final Instant updatedAt;

    private ProfileTemplate(BuilderImpl builder) {
        this.templateName = builder.templateName;
        this.templateQuestions = builder.templateQuestions;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String templateName() {
        return this.templateName;
    }

    public final boolean hasTemplateQuestions() {
        return this.templateQuestions != null && !(this.templateQuestions instanceof SdkAutoConstructList);
    }

    public final List<ProfileTemplateQuestion> templateQuestions() {
        return this.templateQuestions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.templateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTemplateQuestions() ? this.templateQuestions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileTemplate)) {
            return false;
        }
        ProfileTemplate other = (ProfileTemplate)obj;
        return Objects.equals(this.templateName(), other.templateName()) && this.hasTemplateQuestions() == other.hasTemplateQuestions() && Objects.equals(this.templateQuestions(), other.templateQuestions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"ProfileTemplate").add("TemplateName", (Object)this.templateName()).add("TemplateQuestions", this.hasTemplateQuestions() ? this.templateQuestions() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateName": {
                return Optional.ofNullable(clazz.cast(this.templateName()));
            }
            case "TemplateQuestions": {
                return Optional.ofNullable(clazz.cast(this.templateQuestions()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfileTemplate, T> g) {
        return obj -> g.apply((ProfileTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String templateName;
        private List<ProfileTemplateQuestion> templateQuestions = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileTemplate model) {
            this.templateName(model.templateName);
            this.templateQuestions(model.templateQuestions);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getTemplateName() {
            return this.templateName;
        }

        public final void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Override
        public final Builder templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public final List<ProfileTemplateQuestion.Builder> getTemplateQuestions() {
            List<ProfileTemplateQuestion.Builder> result = TemplateQuestionsCopier.copyToBuilder(this.templateQuestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTemplateQuestions(Collection<ProfileTemplateQuestion.BuilderImpl> templateQuestions) {
            this.templateQuestions = TemplateQuestionsCopier.copyFromBuilder(templateQuestions);
        }

        @Override
        public final Builder templateQuestions(Collection<ProfileTemplateQuestion> templateQuestions) {
            this.templateQuestions = TemplateQuestionsCopier.copy(templateQuestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateQuestions(ProfileTemplateQuestion ... templateQuestions) {
            this.templateQuestions(Arrays.asList(templateQuestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder templateQuestions(Consumer<ProfileTemplateQuestion.Builder> ... templateQuestions) {
            this.templateQuestions(Stream.of(templateQuestions).map(c -> (ProfileTemplateQuestion)((ProfileTemplateQuestion.Builder)ProfileTemplateQuestion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public ProfileTemplate build() {
            return new ProfileTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfileTemplate> {
        public Builder templateName(String var1);

        public Builder templateQuestions(Collection<ProfileTemplateQuestion> var1);

        public Builder templateQuestions(ProfileTemplateQuestion ... var1);

        public Builder templateQuestions(Consumer<ProfileTemplateQuestion.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

