/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest;
import software.amazon.awssdk.services.workdocs.model.DescribeGroupsResponse;
import software.amazon.awssdk.services.workdocs.model.GroupMetadata;

public class DescribeGroupsIterable
implements SdkIterable<DescribeGroupsResponse> {
    private final WorkDocsClient client;
    private final DescribeGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeGroupsIterable(WorkDocsClient client, DescribeGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeGroupsResponseFetcher();
    }

    public Iterator<DescribeGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<GroupMetadata> groups() {
        Function<DescribeGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeGroupsResponseFetcher
    implements SyncPageFetcher<DescribeGroupsResponse> {
        private DescribeGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeGroupsResponse nextPage(DescribeGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeGroupsIterable.this.client.describeGroups(DescribeGroupsIterable.this.firstRequest);
            }
            return DescribeGroupsIterable.this.client.describeGroups((DescribeGroupsRequest)((Object)DescribeGroupsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

