/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workdocs.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workdocs.WorkDocsClient;
import software.amazon.awssdk.services.workdocs.internal.UserAgentUtils;
import software.amazon.awssdk.services.workdocs.model.ResponseItem;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesRequest;
import software.amazon.awssdk.services.workdocs.model.SearchResourcesResponse;

public class SearchResourcesIterable
implements SdkIterable<SearchResourcesResponse> {
    private final WorkDocsClient client;
    private final SearchResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchResourcesIterable(WorkDocsClient client, SearchResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new SearchResourcesResponseFetcher();
    }

    public Iterator<SearchResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResponseItem> items() {
        Function<SearchResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchResourcesResponseFetcher
    implements SyncPageFetcher<SearchResourcesResponse> {
        private SearchResourcesResponseFetcher() {
        }

        public boolean hasNextPage(SearchResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public SearchResourcesResponse nextPage(SearchResourcesResponse previousPage) {
            if (previousPage == null) {
                return SearchResourcesIterable.this.client.searchResources(SearchResourcesIterable.this.firstRequest);
            }
            return SearchResourcesIterable.this.client.searchResources((SearchResourcesRequest)((Object)SearchResourcesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

