/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.worklink.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.worklink.WorkLinkClient;
import software.amazon.awssdk.services.worklink.internal.UserAgentUtils;
import software.amazon.awssdk.services.worklink.model.ListDevicesRequest;
import software.amazon.awssdk.services.worklink.model.ListDevicesResponse;

public class ListDevicesIterable
implements SdkIterable<ListDevicesResponse> {
    private final WorkLinkClient client;
    private final ListDevicesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevicesIterable(WorkLinkClient client, ListDevicesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDevicesResponseFetcher();
    }

    public Iterator<ListDevicesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDevicesResponseFetcher
    implements SyncPageFetcher<ListDevicesResponse> {
        private ListDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListDevicesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevicesResponse nextPage(ListDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListDevicesIterable.this.client.listDevices(ListDevicesIterable.this.firstRequest);
            }
            return ListDevicesIterable.this.client.listDevices((ListDevicesRequest)((Object)ListDevicesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

