/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.internal.UserAgentUtils;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsRequest;
import software.amazon.awssdk.services.workmail.model.ListMailDomainsResponse;

public class ListMailDomainsIterable
implements SdkIterable<ListMailDomainsResponse> {
    private final WorkMailClient client;
    private final ListMailDomainsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMailDomainsIterable(WorkMailClient client, ListMailDomainsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMailDomainsResponseFetcher();
    }

    public Iterator<ListMailDomainsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListMailDomainsResponseFetcher
    implements SyncPageFetcher<ListMailDomainsResponse> {
        private ListMailDomainsResponseFetcher() {
        }

        public boolean hasNextPage(ListMailDomainsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMailDomainsResponse nextPage(ListMailDomainsResponse previousPage) {
            if (previousPage == null) {
                return ListMailDomainsIterable.this.client.listMailDomains(ListMailDomainsIterable.this.firstRequest);
            }
            return ListMailDomainsIterable.this.client.listMailDomains((ListMailDomainsRequest)((Object)ListMailDomainsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

