/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RendererType {
    APP_STREAM("AppStream"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RendererType> VALUE_MAP;
    private final String value;

    private RendererType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RendererType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RendererType> knownValues() {
        EnumSet<RendererType> knownValues = EnumSet.allOf(RendererType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RendererType.class, RendererType::toString);
    }
}

