/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebClient;
import software.amazon.awssdk.services.workspacesweb.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;

public class ListTrustStoresIterable
implements SdkIterable<ListTrustStoresResponse> {
    private final WorkSpacesWebClient client;
    private final ListTrustStoresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTrustStoresIterable(WorkSpacesWebClient client, ListTrustStoresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTrustStoresResponseFetcher();
    }

    public Iterator<ListTrustStoresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTrustStoresResponseFetcher
    implements SyncPageFetcher<ListTrustStoresResponse> {
        private ListTrustStoresResponseFetcher() {
        }

        public boolean hasNextPage(ListTrustStoresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTrustStoresResponse nextPage(ListTrustStoresResponse previousPage) {
            if (previousPage == null) {
                return ListTrustStoresIterable.this.client.listTrustStores(ListTrustStoresIterable.this.firstRequest);
            }
            return ListTrustStoresIterable.this.client.listTrustStores((ListTrustStoresRequest)((Object)ListTrustStoresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

