/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesRequest;
import software.amazon.awssdk.services.xray.model.GetInsightSummariesResponse;

public class GetInsightSummariesIterable
implements SdkIterable<GetInsightSummariesResponse> {
    private final XRayClient client;
    private final GetInsightSummariesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetInsightSummariesIterable(XRayClient client, GetInsightSummariesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetInsightSummariesResponseFetcher();
    }

    public Iterator<GetInsightSummariesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class GetInsightSummariesResponseFetcher
    implements SyncPageFetcher<GetInsightSummariesResponse> {
        private GetInsightSummariesResponseFetcher() {
        }

        public boolean hasNextPage(GetInsightSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetInsightSummariesResponse nextPage(GetInsightSummariesResponse previousPage) {
            if (previousPage == null) {
                return GetInsightSummariesIterable.this.client.getInsightSummaries(GetInsightSummariesIterable.this.firstRequest);
            }
            return GetInsightSummariesIterable.this.client.getInsightSummaries((GetInsightSummariesRequest)((Object)GetInsightSummariesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

