/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.xray.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.xray.XRayClient;
import software.amazon.awssdk.services.xray.internal.UserAgentUtils;
import software.amazon.awssdk.services.xray.model.GetServiceGraphRequest;
import software.amazon.awssdk.services.xray.model.GetServiceGraphResponse;
import software.amazon.awssdk.services.xray.model.Service;

public class GetServiceGraphIterable
implements SdkIterable<GetServiceGraphResponse> {
    private final XRayClient client;
    private final GetServiceGraphRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetServiceGraphIterable(XRayClient client, GetServiceGraphRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetServiceGraphResponseFetcher();
    }

    public Iterator<GetServiceGraphResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Service> services() {
        Function<GetServiceGraphResponse, Iterator> getIterator = response -> {
            if (response != null && response.services() != null) {
                return response.services().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetServiceGraphResponseFetcher
    implements SyncPageFetcher<GetServiceGraphResponse> {
        private GetServiceGraphResponseFetcher() {
        }

        public boolean hasNextPage(GetServiceGraphResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetServiceGraphResponse nextPage(GetServiceGraphResponse previousPage) {
            if (previousPage == null) {
                return GetServiceGraphIterable.this.client.getServiceGraph(GetServiceGraphIterable.this.firstRequest);
            }
            return GetServiceGraphIterable.this.client.getServiceGraph((GetServiceGraphRequest)((Object)GetServiceGraphIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

